/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.jwt;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class JWTAssertionDetailsVerifier
extends DefaultJWTClaimsVerifier {
    private final Set<Audience> expectedAudience;
    private final long expMaxAhead;

    public JWTAssertionDetailsVerifier(Set<Audience> set) {
        this(set, -1L);
    }

    public JWTAssertionDetailsVerifier(Set<Audience> set, long l2) {
        super(new HashSet<String>(Identifier.toStringList(set)), null, new HashSet<String>(Arrays.asList("aud", "exp", "sub", "iss")), null);
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = set;
        this.expMaxAhead = l2;
    }

    @Deprecated
    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    public long getExpirationTimeMaxAhead() {
        return this.expMaxAhead;
    }

    @Override
    public void verify(JWTClaimsSet jWTClaimsSet, SecurityContext securityContext) throws BadJWTException {
        long l2;
        long l3;
        super.verify(jWTClaimsSet, securityContext);
        if (this.expMaxAhead > 0L && (l3 = DateUtils.toSecondsSinceEpoch(new Date())) + this.expMaxAhead < (l2 = DateUtils.toSecondsSinceEpoch(jWTClaimsSet.getExpirationTime()))) {
            throw new BadJWTException("JWT expiration too far ahead");
        }
    }
}

