/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParameterRequirement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ResourceUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class TokenRequest
extends AbstractOptionallyIdentifiedRequest {
    private final AuthorizationGrant authzGrant;
    private final Scope scope;
    private final List<AuthorizationDetail> authorizationDetails;
    private final List<URI> resources;
    private final RefreshToken existingGrant;
    private final Map<String, List<String>> customParams;
    private static final Set<String> ALLOWED_REPEATED_PARAMS = new HashSet<String>(Arrays.asList("resource", "audience"));

    public TokenRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationGrant authorizationGrant, Scope scope) {
        this(uRI, clientAuthentication, authorizationGrant, scope, null, null);
    }

    public TokenRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationGrant authorizationGrant, Scope scope, List<URI> list, Map<String, List<String>> map) {
        this(uRI, clientAuthentication, authorizationGrant, scope, null, list, map);
    }

    public TokenRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationGrant authorizationGrant, Scope scope, List<AuthorizationDetail> list, List<URI> list2, Map<String, List<String>> map) {
        super(uRI, clientAuthentication);
        if (clientAuthentication == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.authzGrant = authorizationGrant;
        this.scope = scope;
        if (list2 != null) {
            for (URI uRI2 : list2) {
                if (ResourceUtils.isLegalResourceURI(uRI2)) continue;
                throw new IllegalArgumentException("Resource URI must be absolute and with no query or fragment: " + uRI2);
            }
        }
        this.authorizationDetails = list;
        this.resources = list2;
        this.existingGrant = null;
        this.customParams = MapUtils.isNotEmpty(map) ? map : Collections.emptyMap();
    }

    public TokenRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationGrant authorizationGrant) {
        this(uRI, clientAuthentication, authorizationGrant, null);
    }

    public TokenRequest(URI uRI, ClientID clientID, AuthorizationGrant authorizationGrant, Scope scope) {
        this(uRI, clientID, authorizationGrant, scope, null, null, null);
    }

    public TokenRequest(URI uRI, ClientID clientID, AuthorizationGrant authorizationGrant, Scope scope, List<URI> list, RefreshToken refreshToken, Map<String, List<String>> map) {
        this(uRI, clientID, authorizationGrant, scope, null, list, refreshToken, map);
    }

    public TokenRequest(URI uRI, ClientID clientID, AuthorizationGrant authorizationGrant, Scope scope, List<AuthorizationDetail> list, List<URI> list2, RefreshToken refreshToken, Map<String, List<String>> map) {
        super(uRI, clientID);
        if (authorizationGrant.getType().requiresClientAuthentication()) {
            throw new IllegalArgumentException("The \"" + authorizationGrant.getType() + "\" grant type requires client authentication");
        }
        if (authorizationGrant.getType().requiresClientID() && clientID == null) {
            throw new IllegalArgumentException("The \"" + authorizationGrant.getType() + "\" grant type requires a \"client_id\" parameter");
        }
        this.authzGrant = authorizationGrant;
        this.scope = scope;
        this.authorizationDetails = list;
        if (list2 != null) {
            for (URI uRI2 : list2) {
                if (ResourceUtils.isLegalResourceURI(uRI2)) continue;
                throw new IllegalArgumentException("Resource URI must be absolute and with no query or fragment: " + uRI2);
            }
        }
        this.resources = list2;
        this.existingGrant = refreshToken;
        this.customParams = MapUtils.isNotEmpty(map) ? map : Collections.emptyMap();
    }

    public TokenRequest(URI uRI, ClientID clientID, AuthorizationGrant authorizationGrant) {
        this(uRI, clientID, authorizationGrant, null);
    }

    public TokenRequest(URI uRI, AuthorizationGrant authorizationGrant, Scope scope) {
        this(uRI, (ClientID)null, authorizationGrant, scope);
    }

    public TokenRequest(URI uRI, AuthorizationGrant authorizationGrant) {
        this(uRI, (ClientID)null, authorizationGrant, null);
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<AuthorizationDetail> getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public List<URI> getResources() {
        return this.resources;
    }

    public RefreshToken getExistingGrant() {
        return this.existingGrant;
    }

    public Map<String, List<String>> getCustomParameters() {
        return Collections.unmodifiableMap(this.customParams);
    }

    public List<String> getCustomParameter(String string) {
        return this.customParams.get(string);
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        LinkedHashMap<String, List<String>> linkedHashMap;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        try {
            linkedHashMap = new LinkedHashMap<String, List<String>>(hTTPRequest.getBodyAsFormParameters());
        }
        catch (ParseException parseException) {
            throw new SerializeException(parseException.getMessage(), parseException);
        }
        linkedHashMap.putAll(this.authzGrant.toParameters());
        switch (this.authzGrant.getType().getScopeRequirementInTokenRequest()) {
            case REQUIRED: {
                if (CollectionUtils.isEmpty(this.scope)) {
                    throw new SerializeException("Scope is required for the " + this.authzGrant.getType() + " grant");
                }
                linkedHashMap.put("scope", Collections.singletonList(this.scope.toString()));
                break;
            }
            case OPTIONAL: {
                if (!CollectionUtils.isNotEmpty(this.scope)) break;
                linkedHashMap.put("scope", Collections.singletonList(this.scope.toString()));
                break;
            }
        }
        if (this.getClientID() != null) {
            linkedHashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        }
        if (this.getAuthorizationDetails() != null) {
            linkedHashMap.put("authorization_details", Collections.singletonList(AuthorizationDetail.toJSONString(this.getAuthorizationDetails())));
        }
        if (this.getResources() != null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (URI uRI : this.resources) {
                if (uRI == null) continue;
                linkedList.add(uRI.toString());
            }
            linkedHashMap.put("resource", linkedList);
        }
        if (this.getExistingGrant() != null) {
            linkedHashMap.put("existing_grant", Collections.singletonList(this.existingGrant.getValue()));
        }
        if (!this.getCustomParameters().isEmpty()) {
            linkedHashMap.putAll(this.getCustomParameters());
        }
        hTTPRequest.setBody(URLUtils.serializeParameters(linkedHashMap));
        return hTTPRequest;
    }

    public static TokenRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        Object object;
        Object object2;
        Object object3;
        String string;
        ClientAuthentication clientAuthentication;
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        try {
            clientAuthentication = ClientAuthentication.parse(hTTPRequest);
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + parseException.getMessage()));
        }
        Map map = hTTPRequest.getBodyAsFormParameters();
        Set<String> set = MultivaluedMapUtils.getKeysWithMoreThanOneValue(map, ALLOWED_REPEATED_PARAMS);
        if (!set.isEmpty()) {
            String string2 = "Parameter(s) present more than once: " + set;
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.setDescription(string2));
        }
        if (clientAuthentication instanceof ClientSecretBasic && (StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(map, "client_assertion")) || StringUtils.isNotBlank((CharSequence)MultivaluedMapUtils.getFirstValue(map, "client_assertion_type")))) {
            String string3 = "Multiple conflicting client authentication methods found: Basic and JWT assertion";
            throw new ParseException(string3, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string3));
        }
        AuthorizationGrant authorizationGrant = AuthorizationGrant.parse(map);
        if (clientAuthentication == null && authorizationGrant.getType().requiresClientAuthentication()) {
            String string4 = "Missing client authentication";
            throw new ParseException(string4, OAuth2Error.INVALID_CLIENT.appendDescription(": " + string4));
        }
        ClientID clientID = null;
        if (clientAuthentication == null) {
            string = (String)MultivaluedMapUtils.getFirstValue(map, "client_id");
            if (string != null && !string.trim().isEmpty()) {
                clientID = new ClientID(string);
            }
            if (clientID == null && authorizationGrant.getType().requiresClientID()) {
                String string5 = "Missing required client_id parameter";
                throw new ParseException(string5, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string5));
            }
        }
        string = (String)MultivaluedMapUtils.getFirstValue(map, "scope");
        ParameterRequirement parameterRequirement = authorizationGrant.getType().getScopeRequirementInTokenRequest();
        Scope scope = null;
        if (string != null && (ParameterRequirement.REQUIRED.equals((Object)parameterRequirement) || ParameterRequirement.OPTIONAL.equals((Object)parameterRequirement))) {
            scope = Scope.parse(string);
        }
        String string6 = (String)MultivaluedMapUtils.getFirstValue(map, "authorization_details");
        List<AuthorizationDetail> list = null;
        if (string6 != null) {
            list = AuthorizationDetail.parseList(string6);
        }
        LinkedList<URI> linkedList = null;
        List list2 = (List)map.get("resource");
        if (list2 != null) {
            linkedList = new LinkedList<URI>();
            object3 = list2.iterator();
            while (object3.hasNext()) {
                URI uRI2;
                object2 = (String)object3.next();
                if (object2 == null) continue;
                object = "Illegal resource parameter: Must be an absolute URI without a fragment: " + (String)object2;
                try {
                    uRI2 = new URI((String)object2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ParseException((String)object, OAuth2Error.INVALID_TARGET.setDescription((String)object));
                }
                if (!ResourceUtils.isLegalResourceURI(uRI2)) {
                    throw new ParseException((String)object, OAuth2Error.INVALID_TARGET.setDescription((String)object));
                }
                linkedList.add(uRI2);
            }
        }
        object2 = StringUtils.isNotBlank((CharSequence)(object3 = (String)MultivaluedMapUtils.getFirstValue(map, "existing_grant"))) ? new RefreshToken((String)object3) : null;
        object = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("grant_type") || ((String)entry.getKey()).equalsIgnoreCase("client_id") || ((String)entry.getKey()).equalsIgnoreCase("client_secret") || ((String)entry.getKey()).equalsIgnoreCase("client_assertion_type") || ((String)entry.getKey()).equalsIgnoreCase("client_assertion") || ((String)entry.getKey()).equalsIgnoreCase("scope") || ((String)entry.getKey()).equalsIgnoreCase("authorization_details") || ((String)entry.getKey()).equalsIgnoreCase("resource") || ((String)entry.getKey()).equalsIgnoreCase("existing_grant") || authorizationGrant.getType().getRequestParameterNames().contains(entry.getKey())) continue;
            object.put(entry.getKey(), entry.getValue());
        }
        if (clientAuthentication != null) {
            return new TokenRequest(uRI, clientAuthentication, authorizationGrant, scope, list, linkedList, (Map<String, List<String>>)object);
        }
        return new TokenRequest(uRI, clientID, authorizationGrant, scope, list, linkedList, (RefreshToken)object2, (Map<String, List<String>>)object);
    }
}

