/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractOptionallyAuthenticatedRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.Token;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class TokenIntrospectionRequest
extends AbstractOptionallyAuthenticatedRequest {
    private final Token token;
    private final AccessToken clientAuthz;
    private final Map<String, List<String>> customParams;

    public TokenIntrospectionRequest(URI uRI, Token token) {
        this(uRI, token, null);
    }

    public TokenIntrospectionRequest(URI uRI, Token token, Map<String, List<String>> map) {
        super(uRI, null);
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
        this.clientAuthz = null;
        this.customParams = map != null ? map : Collections.emptyMap();
    }

    public TokenIntrospectionRequest(URI uRI, ClientAuthentication clientAuthentication, Token token) {
        this(uRI, clientAuthentication, token, null);
    }

    public TokenIntrospectionRequest(URI uRI, ClientAuthentication clientAuthentication, Token token, Map<String, List<String>> map) {
        super(uRI, clientAuthentication);
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
        this.clientAuthz = null;
        this.customParams = map != null ? map : Collections.emptyMap();
    }

    public TokenIntrospectionRequest(URI uRI, AccessToken accessToken, Token token) {
        this(uRI, accessToken, token, null);
    }

    public TokenIntrospectionRequest(URI uRI, AccessToken accessToken, Token token, Map<String, List<String>> map) {
        super(uRI, null);
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
        this.clientAuthz = accessToken;
        this.customParams = map != null ? map : Collections.emptyMap();
    }

    public AccessToken getClientAuthorization() {
        return this.clientAuthz;
    }

    public Token getToken() {
        return this.token;
    }

    public Map<String, List<String>> getCustomParameters() {
        return this.customParams;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("token", Collections.singletonList(this.token.getValue()));
        if (this.token instanceof AccessToken) {
            hashMap.put("token_type_hint", Collections.singletonList("access_token"));
        } else if (this.token instanceof RefreshToken) {
            hashMap.put("token_type_hint", Collections.singletonList("refresh_token"));
        }
        hashMap.putAll(this.customParams);
        hTTPRequest.setBody(URLUtils.serializeParameters(hashMap));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        if (this.clientAuthz != null) {
            hTTPRequest.setAuthorization(this.clientAuthz.toAuthorizationHeader());
        }
        return hTTPRequest;
    }

    public static TokenIntrospectionRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        Map map = hTTPRequest.getBodyAsFormParameters();
        final String string = (String)MultivaluedMapUtils.removeAndReturnFirstValue(map, "token");
        if (string == null || string.isEmpty()) {
            throw new ParseException("Missing required token parameter");
        }
        Token token = null;
        String string2 = (String)MultivaluedMapUtils.removeAndReturnFirstValue(map, "token_type_hint");
        if (string2 == null) {
            token = new Token(){
                private static final long serialVersionUID = 8491102820261331059L;

                @Override
                public String getValue() {
                    return string;
                }

                @Override
                public Set<String> getParameterNames() {
                    return Collections.emptySet();
                }

                @Override
                public JSONObject toJSONObject() {
                    return new JSONObject();
                }

                @Override
                public boolean equals(Object object) {
                    return object instanceof Token && object.toString().equals(string);
                }
            };
        } else if (string2.equals("access_token")) {
            token = new TypelessAccessToken(string);
        } else if (string2.equals("refresh_token")) {
            token = new RefreshToken(string);
        }
        ClientAuthentication clientAuthentication = ClientAuthentication.parse(hTTPRequest);
        AccessToken accessToken = null;
        if (clientAuthentication == null && hTTPRequest.getAuthorization() != null) {
            accessToken = AccessToken.parse(hTTPRequest.getAuthorization());
        }
        URI uRI = hTTPRequest.getURI();
        if (accessToken != null) {
            return new TokenIntrospectionRequest(uRI, accessToken, token, (Map<String, List<String>>)map);
        }
        return new TokenIntrospectionRequest(uRI, clientAuthentication, token, (Map<String, List<String>>)map);
    }
}

