/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class RefreshTokenGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.REFRESH_TOKEN;
    private final RefreshToken refreshToken;

    public RefreshTokenGrant(RefreshToken refreshToken) {
        super(GRANT_TYPE);
        if (refreshToken == null) {
            throw new IllegalArgumentException("The refresh token must not be null");
        }
        this.refreshToken = refreshToken;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        linkedHashMap.put("refresh_token", Collections.singletonList(this.refreshToken.getValue()));
        return linkedHashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RefreshTokenGrant refreshTokenGrant = (RefreshTokenGrant)object;
        return this.refreshToken.equals(refreshTokenGrant.refreshToken);
    }

    public int hashCode() {
        return this.refreshToken.hashCode();
    }

    public static RefreshTokenGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        String string = MultivaluedMapUtils.getFirstValue(map, "refresh_token");
        if (string == null || string.trim().isEmpty()) {
            String string2 = "Missing or empty refresh_token parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        RefreshToken refreshToken = new RefreshToken(string);
        return new RefreshTokenGrant(refreshToken);
    }
}

