/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc;

import java.security.Key;
import java.text.ParseException;
import java.util.List;
import java.util.ListIterator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJWEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJWSException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEDecrypterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWEKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.EncryptedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;

public class DefaultJWTProcessor<C extends SecurityContext>
implements ConfigurableJWTProcessor<C> {
    private JOSEObjectTypeVerifier<C> jwsTypeVerifier = DefaultJOSEObjectTypeVerifier.JWT;
    private JOSEObjectTypeVerifier<C> jweTypeVerifier = DefaultJOSEObjectTypeVerifier.JWT;
    private JWSKeySelector<C> jwsKeySelector;
    private JWTClaimsSetAwareJWSKeySelector<C> claimsSetAwareJWSKeySelector;
    private JWEKeySelector<C> jweKeySelector;
    private JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();
    private JWEDecrypterFactory jweDecrypterFactory = new DefaultJWEDecrypterFactory();
    private JWTClaimsSetVerifier<C> claimsVerifier = new DefaultJWTClaimsVerifier(null, null);

    @Override
    public JOSEObjectTypeVerifier<C> getJWSTypeVerifier() {
        return this.jwsTypeVerifier;
    }

    @Override
    public void setJWSTypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jwsTypeVerifier = jOSEObjectTypeVerifier;
    }

    @Override
    public JWSKeySelector<C> getJWSKeySelector() {
        return this.jwsKeySelector;
    }

    @Override
    public void setJWSKeySelector(JWSKeySelector<C> jWSKeySelector) {
        this.jwsKeySelector = jWSKeySelector;
    }

    @Override
    public JWTClaimsSetAwareJWSKeySelector<C> getJWTClaimsSetAwareJWSKeySelector() {
        return this.claimsSetAwareJWSKeySelector;
    }

    @Override
    public void setJWTClaimsSetAwareJWSKeySelector(JWTClaimsSetAwareJWSKeySelector<C> jWTClaimsSetAwareJWSKeySelector) {
        this.claimsSetAwareJWSKeySelector = jWTClaimsSetAwareJWSKeySelector;
    }

    @Override
    public JOSEObjectTypeVerifier<C> getJWETypeVerifier() {
        return this.jweTypeVerifier;
    }

    @Override
    public void setJWETypeVerifier(JOSEObjectTypeVerifier<C> jOSEObjectTypeVerifier) {
        this.jweTypeVerifier = jOSEObjectTypeVerifier;
    }

    @Override
    public JWEKeySelector<C> getJWEKeySelector() {
        return this.jweKeySelector;
    }

    @Override
    public void setJWEKeySelector(JWEKeySelector<C> jWEKeySelector) {
        this.jweKeySelector = jWEKeySelector;
    }

    @Override
    public JWSVerifierFactory getJWSVerifierFactory() {
        return this.jwsVerifierFactory;
    }

    @Override
    public void setJWSVerifierFactory(JWSVerifierFactory jWSVerifierFactory) {
        this.jwsVerifierFactory = jWSVerifierFactory;
    }

    @Override
    public JWEDecrypterFactory getJWEDecrypterFactory() {
        return this.jweDecrypterFactory;
    }

    @Override
    public void setJWEDecrypterFactory(JWEDecrypterFactory jWEDecrypterFactory) {
        this.jweDecrypterFactory = jWEDecrypterFactory;
    }

    @Override
    public JWTClaimsSetVerifier<C> getJWTClaimsSetVerifier() {
        return this.claimsVerifier;
    }

    @Override
    public void setJWTClaimsSetVerifier(JWTClaimsSetVerifier<C> jWTClaimsSetVerifier) {
        this.claimsVerifier = jWTClaimsSetVerifier;
    }

    protected JWTClaimsSet extractJWTClaimsSet(JWT jWT) throws BadJWTException {
        try {
            return jWT.getJWTClaimsSet();
        }
        catch (ParseException parseException) {
            throw new BadJWTException(parseException.getMessage(), parseException);
        }
    }

    protected JWTClaimsSet verifyJWTClaimsSet(JWTClaimsSet jWTClaimsSet, C c2) throws BadJWTException {
        if (this.getJWTClaimsSetVerifier() != null) {
            this.getJWTClaimsSetVerifier().verify(jWTClaimsSet, c2);
        }
        return jWTClaimsSet;
    }

    protected List<? extends Key> selectKeys(JWSHeader jWSHeader, JWTClaimsSet jWTClaimsSet, C c2) throws KeySourceException, BadJOSEException {
        if (this.getJWTClaimsSetAwareJWSKeySelector() != null) {
            return this.getJWTClaimsSetAwareJWSKeySelector().selectKeys(jWSHeader, jWTClaimsSet, c2);
        }
        if (this.getJWSKeySelector() != null) {
            return this.getJWSKeySelector().selectJWSKeys(jWSHeader, c2);
        }
        throw new BadJOSEException("Signed JWT rejected: No JWS key selector is configured");
    }

    @Override
    public JWTClaimsSet process(String string, C c2) throws ParseException, BadJOSEException, JOSEException {
        return this.process(JWTParser.parse(string), c2);
    }

    @Override
    public JWTClaimsSet process(JWT jWT, C c2) throws BadJOSEException, JOSEException {
        if (jWT instanceof SignedJWT) {
            return this.process((SignedJWT)jWT, c2);
        }
        if (jWT instanceof EncryptedJWT) {
            return this.process((EncryptedJWT)jWT, c2);
        }
        if (jWT instanceof PlainJWT) {
            return this.process((PlainJWT)jWT, c2);
        }
        throw new JOSEException("Unexpected JWT object type: " + jWT.getClass());
    }

    @Override
    public JWTClaimsSet process(PlainJWT plainJWT, C c2) throws BadJOSEException, JOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("Plain JWT rejected: No JWS header typ (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(plainJWT.getHeader().getType(), c2);
        throw new BadJOSEException("Unsecured (plain) JWTs are rejected, extend class to handle");
    }

    @Override
    public JWTClaimsSet process(SignedJWT signedJWT, C c2) throws BadJOSEException, JOSEException {
        if (this.jwsTypeVerifier == null) {
            throw new BadJOSEException("Signed JWT rejected: No JWS header typ (type) verifier is configured");
        }
        this.jwsTypeVerifier.verify(signedJWT.getHeader().getType(), c2);
        if (this.getJWSKeySelector() == null && this.getJWTClaimsSetAwareJWSKeySelector() == null) {
            throw new BadJOSEException("Signed JWT rejected: No JWS key selector is configured");
        }
        if (this.getJWSVerifierFactory() == null) {
            throw new JOSEException("No JWS verifier is configured");
        }
        JWTClaimsSet jWTClaimsSet = this.extractJWTClaimsSet(signedJWT);
        List<Key> list = this.selectKeys(signedJWT.getHeader(), jWTClaimsSet, c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("Signed JWT rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator<Key> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWSVerifier jWSVerifier = this.getJWSVerifierFactory().createJWSVerifier(signedJWT.getHeader(), listIterator.next());
            if (jWSVerifier == null) continue;
            boolean bl2 = signedJWT.verify(jWSVerifier);
            if (bl2) {
                return this.verifyJWTClaimsSet(jWTClaimsSet, c2);
            }
            if (listIterator.hasNext()) continue;
            throw new BadJWSException("Signed JWT rejected: Invalid signature");
        }
        throw new BadJOSEException("JWS object rejected: No matching verifier(s) found");
    }

    @Override
    public JWTClaimsSet process(EncryptedJWT encryptedJWT, C c2) throws BadJOSEException, JOSEException {
        if (this.jweTypeVerifier == null) {
            throw new BadJOSEException("Encrypted JWT rejected: No JWE header typ (type) verifier is configured");
        }
        this.jweTypeVerifier.verify(encryptedJWT.getHeader().getType(), c2);
        if (this.getJWEKeySelector() == null) {
            throw new BadJOSEException("Encrypted JWT rejected: No JWE key selector is configured");
        }
        if (this.getJWEDecrypterFactory() == null) {
            throw new JOSEException("No JWE decrypter is configured");
        }
        List<Key> list = this.getJWEKeySelector().selectJWEKeys(encryptedJWT.getHeader(), c2);
        if (list == null || list.isEmpty()) {
            throw new BadJOSEException("Encrypted JWT rejected: Another algorithm expected, or no matching key(s) found");
        }
        ListIterator<Key> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            JWEDecrypter jWEDecrypter = this.getJWEDecrypterFactory().createJWEDecrypter(encryptedJWT.getHeader(), listIterator.next());
            if (jWEDecrypter == null) continue;
            try {
                encryptedJWT.decrypt(jWEDecrypter);
            }
            catch (JOSEException jOSEException) {
                if (listIterator.hasNext()) continue;
                throw new BadJWEException("Encrypted JWT rejected: " + jOSEException.getMessage(), jOSEException);
            }
            if ("JWT".equalsIgnoreCase(encryptedJWT.getHeader().getContentType())) {
                SignedJWT signedJWT = encryptedJWT.getPayload().toSignedJWT();
                if (signedJWT == null) {
                    throw new BadJWTException("The payload is not a nested signed JWT");
                }
                return this.process(signedJWT, c2);
            }
            JWTClaimsSet jWTClaimsSet = this.extractJWTClaimsSet(encryptedJWT);
            return this.verifyJWTClaimsSet(jWTClaimsSet, c2);
        }
        throw new BadJOSEException("Encrypted JWT rejected: No matching decrypter(s) found");
    }
}

