/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

public class X509CertUtils {
    public static final String PEM_BEGIN_MARKER = "-----BEGIN CERTIFICATE-----";
    public static final String PEM_END_MARKER = "-----END CERTIFICATE-----";
    private static Provider jcaProvider;

    public static Provider getProvider() {
        return jcaProvider;
    }

    public static void setProvider(Provider provider) {
        jcaProvider = provider;
    }

    public static X509Certificate parse(byte[] byArray) {
        try {
            return X509CertUtils.parseWithException(byArray);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    public static X509Certificate parseWithException(byte[] byArray) throws CertificateException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        CertificateFactory certificateFactory = jcaProvider != null ? CertificateFactory.getInstance("X.509", jcaProvider) : CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
        if (!(certificate instanceof X509Certificate)) {
            throw new CertificateException("Not a X.509 certificate: " + certificate.getType());
        }
        return (X509Certificate)certificate;
    }

    public static X509Certificate parse(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        int n2 = string.indexOf(PEM_BEGIN_MARKER);
        if (n2 < 0) {
            return null;
        }
        String string2 = string.substring(n2 + PEM_BEGIN_MARKER.length());
        int n3 = string2.indexOf(PEM_END_MARKER);
        if (n3 < 0) {
            return null;
        }
        string2 = string2.substring(0, n3);
        string2 = string2.replaceAll("\\s", "");
        return X509CertUtils.parse(new Base64(string2).decode());
    }

    public static X509Certificate parseWithException(String string) throws CertificateException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        int n2 = string.indexOf(PEM_BEGIN_MARKER);
        if (n2 < 0) {
            throw new CertificateException("PEM begin marker not found");
        }
        String string2 = string.substring(n2 + PEM_BEGIN_MARKER.length());
        int n3 = string2.indexOf(PEM_END_MARKER);
        if (n3 < 0) {
            throw new CertificateException("PEM end marker not found");
        }
        string2 = string2.substring(0, n3);
        string2 = string2.replaceAll("\\s", "");
        return X509CertUtils.parseWithException(new Base64(string2).decode());
    }

    public static String toPEMString(X509Certificate x509Certificate) {
        return X509CertUtils.toPEMString(x509Certificate, true);
    }

    public static String toPEMString(X509Certificate x509Certificate, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PEM_BEGIN_MARKER);
        if (bl2) {
            stringBuilder.append('\n');
        }
        try {
            stringBuilder.append(Base64.encode(x509Certificate.getEncoded()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        if (bl2) {
            stringBuilder.append('\n');
        }
        stringBuilder.append(PEM_END_MARKER);
        return stringBuilder.toString();
    }

    public static Base64URL computeSHA256Thumbprint(X509Certificate x509Certificate) {
        try {
            byte[] byArray = x509Certificate.getEncoded();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return Base64URL.encode(messageDigest.digest(byArray));
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            return null;
        }
    }

    public static UUID store(KeyStore keyStore, PrivateKey privateKey, char[] cArray, X509Certificate x509Certificate) throws KeyStoreException {
        UUID uUID = UUID.randomUUID();
        keyStore.setKeyEntry(uUID.toString(), privateKey, cArray, new Certificate[]{x509Certificate});
        return uUID;
    }
}

