/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IntegerOverflowException;

public class ByteUtils {
    public static byte[] concat(byte[] ... byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (byte[] byArray2 : byArray) {
                if (byArray2 == null) continue;
                byteArrayOutputStream.write(byArray2);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    public static byte[] subArray(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static int bitLength(int n2) {
        return n2 * 8;
    }

    public static int safeBitLength(int n2) throws IntegerOverflowException {
        long l2 = (long)n2 * 8L;
        if ((long)((int)l2) != l2) {
            throw new IntegerOverflowException();
        }
        return (int)l2;
    }

    public static int bitLength(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        return ByteUtils.bitLength(byArray.length);
    }

    public static int safeBitLength(byte[] byArray) throws IntegerOverflowException {
        if (byArray == null) {
            return 0;
        }
        return ByteUtils.safeBitLength(byArray.length);
    }

    public static int byteLength(int n2) {
        return n2 / 8;
    }

    public static boolean isZeroFilled(byte[] byArray) {
        for (byte by2 : byArray) {
            if (by2 == 0) continue;
            return false;
        }
        return true;
    }
}

