/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64Codec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.BigIntegerUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONStringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

@Immutable
public class Base64
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String value;

    public Base64(String string) {
        this.value = Objects.requireNonNull(string);
    }

    public byte[] decode() {
        return Base64Codec.decode(this.value);
    }

    public BigInteger decodeToBigInteger() {
        return new BigInteger(1, this.decode());
    }

    public String decodeToString() {
        return new String(this.decode(), StandardCharset.UTF_8);
    }

    public String toJSONString() {
        return JSONStringUtils.toJSONString(this.value);
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Base64 && this.toString().equals(object.toString());
    }

    public static Base64 from(String string) {
        if (string == null) {
            return null;
        }
        return new Base64(string);
    }

    public static Base64 encode(byte[] byArray) {
        return new Base64(Base64Codec.encodeToString(byArray, false));
    }

    public static Base64 encode(BigInteger bigInteger) {
        return Base64.encode(BigIntegerUtils.toBytesUnsigned(bigInteger));
    }

    public static Base64 encode(String string) {
        return Base64.encode(string.getBytes(StandardCharset.UTF_8));
    }
}

