/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.FieldNamingStrategy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonIOException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.ReflectionAccessFilter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.annotations.JsonAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.annotations.SerializedName;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.$Gson$Types;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.ConstructorConstructor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.Excluder;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.ObjectConstructor;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.Primitives;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.ReflectionAccessFilterHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.TroubleshootingGuide;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.reflect.ReflectionHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonWriter;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    private final List<ReflectionAccessFilter> reflectionFilters;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory, List<ReflectionAccessFilter> list) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterAnnotationTypeAdapterFactory;
        this.reflectionFilters = list;
    }

    private boolean includeField(Field field, boolean bl2) {
        return !this.excluder.excludeField(field, bl2);
    }

    private List<String> getFieldNames(Field field) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        if (serializedName == null) {
            String string = this.fieldNamingPolicy.translateName(field);
            return Collections.singletonList(string);
        }
        String string = serializedName.value();
        String[] stringArray = serializedName.alternate();
        if (stringArray.length == 0) {
            return Collections.singletonList(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        arrayList.add(string);
        Collections.addAll(arrayList, stringArray);
        return arrayList;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        boolean bl2;
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (ReflectionHelper.isAnonymousOrNonStaticLocal(clazz)) {
            return new TypeAdapter<T>(){

                @Override
                public T read(JsonReader jsonReader) throws IOException {
                    jsonReader.skipValue();
                    return null;
                }

                @Override
                public void write(JsonWriter jsonWriter, T t2) throws IOException {
                    jsonWriter.nullValue();
                }

                public String toString() {
                    return "AnonymousOrNonStaticLocalClassAdapter";
                }
            };
        }
        ReflectionAccessFilter.FilterResult filterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
        if (filterResult == ReflectionAccessFilter.FilterResult.BLOCK_ALL) {
            throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + ". Register a TypeAdapter for this type or adjust the access filter.");
        }
        boolean bl3 = bl2 = filterResult == ReflectionAccessFilter.FilterResult.BLOCK_INACCESSIBLE;
        if (ReflectionHelper.isRecord(clazz)) {
            RecordAdapter<T> recordAdapter = new RecordAdapter<T>(clazz, this.getBoundFields(gson, typeToken, clazz, bl2, true), bl2);
            return recordAdapter;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        return new FieldReflectionAdapter<T>(objectConstructor, this.getBoundFields(gson, typeToken, clazz, bl2, false));
    }

    private static <M extends AccessibleObject> void checkAccessible(Object object, M m2) {
        if (!ReflectionAccessFilterHelper.canAccess(m2, Modifier.isStatic(((Member)((Object)m2)).getModifiers()) ? null : object)) {
            String string = ReflectionHelper.getAccessibleObjectDescription(m2, true);
            throw new JsonIOException(string + " is not accessible and ReflectionAccessFilter does not permit making it accessible. Register a TypeAdapter for the declaring type, adjust the access filter or increase the visibility of the element and its declaring type.");
        }
    }

    private BoundField createBoundField(Gson gson, Field field, final Method method, String string, TypeToken<?> typeToken, boolean bl2, final boolean bl3) {
        boolean bl4;
        final boolean bl5 = Primitives.isPrimitive(typeToken.getRawType());
        int n2 = field.getModifiers();
        final boolean bl6 = Modifier.isStatic(n2) && Modifier.isFinal(n2);
        JsonAdapter jsonAdapter = field.getAnnotation(JsonAdapter.class);
        TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper = null;
        if (jsonAdapter != null) {
            typeAdapterRuntimeTypeWrapper = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, typeToken, jsonAdapter, false);
        }
        boolean bl7 = bl4 = typeAdapterRuntimeTypeWrapper != null;
        if (typeAdapterRuntimeTypeWrapper == null) {
            typeAdapterRuntimeTypeWrapper = gson.getAdapter(typeToken);
        }
        final TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper2 = typeAdapterRuntimeTypeWrapper;
        final TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper3 = bl2 ? (bl4 ? typeAdapterRuntimeTypeWrapper2 : new TypeAdapterRuntimeTypeWrapper(gson, typeAdapterRuntimeTypeWrapper2, typeToken.getType())) : typeAdapterRuntimeTypeWrapper2;
        return new BoundField(string, field){

            @Override
            void write(JsonWriter jsonWriter, Object object) throws IOException, IllegalAccessException {
                Object object2;
                if (bl3) {
                    if (method == null) {
                        ReflectiveTypeAdapterFactory.checkAccessible(object, this.field);
                    } else {
                        ReflectiveTypeAdapterFactory.checkAccessible(object, method);
                    }
                }
                if (method != null) {
                    try {
                        object2 = method.invoke(object, new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string = ReflectionHelper.getAccessibleObjectDescription(method, false);
                        throw new JsonIOException("Accessor " + string + " threw exception", invocationTargetException.getCause());
                    }
                } else {
                    object2 = this.field.get(object);
                }
                if (object2 == object) {
                    return;
                }
                jsonWriter.name(this.serializedName);
                typeAdapterRuntimeTypeWrapper3.write(jsonWriter, object2);
            }

            @Override
            void readIntoArray(JsonReader jsonReader, int n2, Object[] objectArray) throws IOException, JsonParseException {
                Object t2 = typeAdapterRuntimeTypeWrapper2.read(jsonReader);
                if (t2 == null && bl5) {
                    throw new JsonParseException("null is not allowed as value for record component '" + this.fieldName + "' of primitive type; at path " + jsonReader.getPath());
                }
                objectArray[n2] = t2;
            }

            @Override
            void readIntoField(JsonReader jsonReader, Object object) throws IOException, IllegalAccessException {
                Object t2 = typeAdapterRuntimeTypeWrapper2.read(jsonReader);
                if (t2 != null || !bl5) {
                    if (bl3) {
                        ReflectiveTypeAdapterFactory.checkAccessible(object, this.field);
                    } else if (bl6) {
                        String string = ReflectionHelper.getAccessibleObjectDescription(this.field, false);
                        throw new JsonIOException("Cannot set value of 'static final' " + string);
                    }
                    this.field.set(object, t2);
                }
            }
        };
    }

    private static IllegalArgumentException createDuplicateFieldException(Class<?> clazz, String string, Field field, Field field2) {
        throw new IllegalArgumentException("Class " + clazz.getName() + " declares multiple JSON fields named '" + string + "'; conflict is caused by fields " + ReflectionHelper.fieldToString(field) + " and " + ReflectionHelper.fieldToString(field2) + "\nSee " + TroubleshootingGuide.createUrl("duplicate-fields"));
    }

    private FieldsData getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz, boolean bl2, boolean bl3) {
        if (clazz.isInterface()) {
            return FieldsData.EMPTY;
        }
        LinkedHashMap<String, BoundField> linkedHashMap = new LinkedHashMap<String, BoundField>();
        LinkedHashMap<String, BoundField> linkedHashMap2 = new LinkedHashMap<String, BoundField>();
        Class<?> clazz2 = clazz;
        while (clazz != Object.class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            if (clazz != clazz2 && fieldArray.length > 0) {
                ReflectionAccessFilter.FilterResult filterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
                if (filterResult == ReflectionAccessFilter.FilterResult.BLOCK_ALL) {
                    throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + " (supertype of " + clazz2 + "). Register a TypeAdapter for this type or adjust the access filter.");
                }
                bl2 = filterResult == ReflectionAccessFilter.FilterResult.BLOCK_INACCESSIBLE;
            }
            for (Field field : fieldArray) {
                Object object;
                Object object2;
                boolean bl4 = this.includeField(field, true);
                boolean bl5 = this.includeField(field, false);
                if (!bl4 && !bl5) continue;
                Method method = null;
                if (bl3) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        bl5 = false;
                    } else {
                        method = ReflectionHelper.getAccessor(clazz, field);
                        if (!bl2) {
                            ReflectionHelper.makeAccessible(method);
                        }
                        if (method.getAnnotation(SerializedName.class) != null && field.getAnnotation(SerializedName.class) == null) {
                            object2 = ReflectionHelper.getAccessibleObjectDescription(method, false);
                            throw new JsonIOException("@SerializedName on " + (String)object2 + " is not supported");
                        }
                    }
                }
                if (!bl2 && method == null) {
                    ReflectionHelper.makeAccessible(field);
                }
                object2 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                List<String> list = this.getFieldNames(field);
                String string = list.get(0);
                BoundField boundField = this.createBoundField(gson, field, method, string, TypeToken.get((Type)object2), bl4, bl2);
                if (bl5) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        String string2 = object.next();
                        BoundField boundField2 = linkedHashMap.put(string2, boundField);
                        if (boundField2 == null) continue;
                        throw ReflectiveTypeAdapterFactory.createDuplicateFieldException(clazz2, string2, boundField2.field, field);
                    }
                }
                if (!bl4 || (object = linkedHashMap2.put(string, boundField)) == null) continue;
                throw ReflectiveTypeAdapterFactory.createDuplicateFieldException(clazz2, string, ((BoundField)object).field, field);
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return new FieldsData(linkedHashMap, new ArrayList<BoundField>(linkedHashMap2.values()));
    }

    private static final class RecordAdapter<T>
    extends Adapter<T, Object[]> {
        static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS = RecordAdapter.primitiveDefaults();
        private final Constructor<T> constructor;
        private final Object[] constructorArgsDefaults;
        private final Map<String, Integer> componentIndices = new HashMap<String, Integer>();

        RecordAdapter(Class<T> clazz, FieldsData fieldsData, boolean bl2) {
            super(fieldsData);
            this.constructor = ReflectionHelper.getCanonicalRecordConstructor(clazz);
            if (bl2) {
                ReflectiveTypeAdapterFactory.checkAccessible(null, this.constructor);
            } else {
                ReflectionHelper.makeAccessible(this.constructor);
            }
            String[] stringArray = ReflectionHelper.getRecordComponentNames(clazz);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.componentIndices.put(stringArray[i2], i2);
            }
            Class<?>[] classArray = this.constructor.getParameterTypes();
            this.constructorArgsDefaults = new Object[classArray.length];
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                this.constructorArgsDefaults[i3] = PRIMITIVE_DEFAULTS.get(classArray[i3]);
            }
        }

        private static Map<Class<?>, Object> primitiveDefaults() {
            HashMap hashMap = new HashMap();
            hashMap.put(Byte.TYPE, (byte)0);
            hashMap.put(Short.TYPE, (short)0);
            hashMap.put(Integer.TYPE, 0);
            hashMap.put(Long.TYPE, 0L);
            hashMap.put(Float.TYPE, Float.valueOf(0.0f));
            hashMap.put(Double.TYPE, 0.0);
            hashMap.put(Character.TYPE, Character.valueOf('\u0000'));
            hashMap.put(Boolean.TYPE, false);
            return hashMap;
        }

        @Override
        Object[] createAccumulator() {
            return (Object[])this.constructorArgsDefaults.clone();
        }

        @Override
        void readField(Object[] objectArray, JsonReader jsonReader, BoundField boundField) throws IOException {
            Integer n2 = this.componentIndices.get(boundField.fieldName);
            if (n2 == null) {
                throw new IllegalStateException("Could not find the index in the constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' for field with name '" + boundField.fieldName + "', unable to determine which argument in the constructor the field corresponds to. This is unexpected behavior, as we expect the RecordComponents to have the same names as the fields in the Java class, and that the order of the RecordComponents is the same as the order of the canonical constructor parameters.");
            }
            boundField.readIntoArray(jsonReader, n2, objectArray);
        }

        @Override
        T finalize(Object[] objectArray) {
            try {
                return this.constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
            catch (IllegalArgumentException | InstantiationException exception) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(objectArray), exception);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(this.constructor) + "' with args " + Arrays.toString(objectArray), invocationTargetException.getCause());
            }
        }
    }

    private static final class FieldReflectionAdapter<T>
    extends Adapter<T, T> {
        private final ObjectConstructor<T> constructor;

        FieldReflectionAdapter(ObjectConstructor<T> objectConstructor, FieldsData fieldsData) {
            super(fieldsData);
            this.constructor = objectConstructor;
        }

        @Override
        T createAccumulator() {
            return this.constructor.construct();
        }

        @Override
        void readField(T t2, JsonReader jsonReader, BoundField boundField) throws IllegalAccessException, IOException {
            boundField.readIntoField(jsonReader, t2);
        }

        @Override
        T finalize(T t2) {
            return t2;
        }
    }

    public static abstract class Adapter<T, A>
    extends TypeAdapter<T> {
        private final FieldsData fieldsData;

        Adapter(FieldsData fieldsData) {
            this.fieldsData = fieldsData;
        }

        @Override
        public void write(JsonWriter jsonWriter, T t2) throws IOException {
            if (t2 == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            try {
                for (BoundField boundField : this.fieldsData.serializedFields) {
                    boundField.write(jsonWriter, t2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
            jsonWriter.endObject();
        }

        @Override
        public T read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            A a2 = this.createAccumulator();
            Map<String, BoundField> map = this.fieldsData.deserializedFields;
            try {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String string = jsonReader.nextName();
                    BoundField boundField = map.get(string);
                    if (boundField == null) {
                        jsonReader.skipValue();
                        continue;
                    }
                    this.readField(a2, jsonReader, boundField);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new JsonSyntaxException(illegalStateException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
            jsonReader.endObject();
            return this.finalize(a2);
        }

        abstract A createAccumulator();

        abstract void readField(A var1, JsonReader var2, BoundField var3) throws IllegalAccessException, IOException;

        abstract T finalize(A var1);
    }

    static abstract class BoundField {
        final String serializedName;
        final Field field;
        final String fieldName;

        protected BoundField(String string, Field field) {
            this.serializedName = string;
            this.field = field;
            this.fieldName = field.getName();
        }

        abstract void write(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void readIntoArray(JsonReader var1, int var2, Object[] var3) throws IOException, JsonParseException;

        abstract void readIntoField(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }

    private static class FieldsData {
        public static final FieldsData EMPTY = new FieldsData(Collections.emptyMap(), Collections.emptyList());
        public final Map<String, BoundField> deserializedFields;
        public final List<BoundField> serializedFields;

        public FieldsData(Map<String, BoundField> map, List<BoundField> list) {
            this.deserializedFields = map;
            this.serializedFields = list;
        }
    }
}

