/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson;

import java.io.IOException;
import java.math.BigDecimal;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.ToNumberStrategy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.LazilyParsedNumber;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.NumberLimits;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.MalformedJsonException;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public Double readNumber(JsonReader jsonReader) throws IOException {
            return jsonReader.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(JsonReader jsonReader) throws IOException {
            return new LazilyParsedNumber(jsonReader.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(JsonReader jsonReader) throws IOException, JsonParseException {
            String string = jsonReader.nextString();
            if (string.indexOf(46) >= 0) {
                return this.parseAsDouble(string, jsonReader);
            }
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                return this.parseAsDouble(string, jsonReader);
            }
        }

        private Number parseAsDouble(String string, JsonReader jsonReader) throws IOException {
            try {
                Double d2 = Double.valueOf(string);
                if ((d2.isInfinite() || d2.isNaN()) && !jsonReader.isLenient()) {
                    throw new MalformedJsonException("JSON forbids NaN and infinities: " + d2 + "; at path " + jsonReader.getPreviousPath());
                }
                return d2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonParseException("Cannot parse " + string + "; at path " + jsonReader.getPreviousPath(), numberFormatException);
            }
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(JsonReader jsonReader) throws IOException {
            String string = jsonReader.nextString();
            try {
                return NumberLimits.parseBigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JsonParseException("Cannot parse " + string + "; at path " + jsonReader.getPreviousPath(), numberFormatException);
            }
        }
    };

}

