/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson;

import java.lang.reflect.Field;
import java.util.Locale;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.FieldNamingStrategy;

public enum FieldNamingPolicy implements FieldNamingStrategy
{
    IDENTITY{

        @Override
        public String translateName(Field field) {
            return field.getName();
        }
    }
    ,
    UPPER_CAMEL_CASE{

        @Override
        public String translateName(Field field) {
            return 2.upperCaseFirstLetter(field.getName());
        }
    }
    ,
    UPPER_CAMEL_CASE_WITH_SPACES{

        @Override
        public String translateName(Field field) {
            return 3.upperCaseFirstLetter(3.separateCamelCase(field.getName(), ' '));
        }
    }
    ,
    UPPER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field field) {
            return 4.separateCamelCase(field.getName(), '_').toUpperCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_UNDERSCORES{

        @Override
        public String translateName(Field field) {
            return 5.separateCamelCase(field.getName(), '_').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DASHES{

        @Override
        public String translateName(Field field) {
            return 6.separateCamelCase(field.getName(), '-').toLowerCase(Locale.ENGLISH);
        }
    }
    ,
    LOWER_CASE_WITH_DOTS{

        @Override
        public String translateName(Field field) {
            return 7.separateCamelCase(field.getName(), '.').toLowerCase(Locale.ENGLISH);
        }
    };


    static String separateCamelCase(String string, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            if (Character.isUpperCase(c3) && stringBuilder.length() != 0) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(c3);
        }
        return stringBuilder.toString();
    }

    static String upperCaseFirstLetter(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isLetter(c2)) continue;
            if (Character.isUpperCase(c2)) {
                return string;
            }
            char c3 = Character.toUpperCase(c2);
            if (i2 == 0) {
                return c3 + string.substring(1);
            }
            return string.substring(0, i2) + c3 + string.substring(i2 + 1);
        }
        return string;
    }
}

