/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc;

import java.net.URL;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RemoteJWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.AbstractJWKSelectorWithSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSVerificationKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;

public class JWSAlgorithmFamilyJWSKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWSKeySelector<C> {
    private final Map<JWSAlgorithm, JWSKeySelector<C>> selectors = new HashMap<JWSAlgorithm, JWSKeySelector<C>>();

    public JWSAlgorithmFamilyJWSKeySelector(JWSAlgorithm.Family family, JWKSource<C> jWKSource) {
        super(jWKSource);
        for (JWSAlgorithm jWSAlgorithm : family) {
            this.selectors.put(jWSAlgorithm, new JWSVerificationKeySelector<C>(jWSAlgorithm, jWKSource));
        }
    }

    @Override
    public List<? extends Key> selectJWSKeys(JWSHeader jWSHeader, C c2) throws KeySourceException {
        JWSKeySelector<C> jWSKeySelector = this.selectors.get(jWSHeader.getAlgorithm());
        if (jWSKeySelector == null) {
            return Collections.emptyList();
        }
        return jWSKeySelector.selectJWSKeys(jWSHeader, c2);
    }

    public static <C extends SecurityContext> JWSAlgorithmFamilyJWSKeySelector<C> fromJWKSetURL(URL uRL) throws KeySourceException {
        RemoteJWKSet remoteJWKSet = new RemoteJWKSet(uRL);
        return JWSAlgorithmFamilyJWSKeySelector.fromJWKSource(remoteJWKSet);
    }

    public static <C extends SecurityContext> JWSAlgorithmFamilyJWSKeySelector<C> fromJWKSource(JWKSource<C> jWKSource) throws KeySourceException {
        JWKMatcher jWKMatcher = new JWKMatcher.Builder().publicOnly(true).keyUses(KeyUse.SIGNATURE, null).keyTypes(KeyType.RSA, KeyType.EC).build();
        List<JWK> list = jWKSource.get(new JWKSelector(jWKMatcher), null);
        for (JWK jWK : list) {
            if (KeyType.RSA.equals(jWK.getKeyType())) {
                return new JWSAlgorithmFamilyJWSKeySelector<C>(JWSAlgorithm.Family.RSA, jWKSource);
            }
            if (!KeyType.EC.equals(jWK.getKeyType())) continue;
            return new JWSAlgorithmFamilyJWSKeySelector<C>(JWSAlgorithm.Family.EC, jWKSource);
        }
        throw new KeySourceException("Couldn't retrieve JWKs");
    }
}

