/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetRetrievalException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Resource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;

@ThreadSafe
public class URLBasedJWKSetSource<C extends SecurityContext>
implements JWKSetSource<C> {
    private final URL url;
    private final ResourceRetriever resourceRetriever;

    public URLBasedJWKSetSource(URL uRL, ResourceRetriever resourceRetriever) {
        Objects.requireNonNull(uRL, "The URL must not be null");
        this.url = uRL;
        Objects.requireNonNull(resourceRetriever, "The resource retriever must not be null");
        this.resourceRetriever = resourceRetriever;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        Resource resource;
        try {
            resource = this.resourceRetriever.retrieveResource(this.url);
        }
        catch (IOException iOException) {
            throw new JWKSetRetrievalException("Couldn't retrieve JWK set from URL: " + iOException.getMessage(), iOException);
        }
        try {
            return JWKSet.parse(resource.getContent());
        }
        catch (Exception exception) {
            throw new JWKSetParseException("Unable to parse JWK set", exception);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

