/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.net.URL;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.CachingJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetBasedJWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSourceWithHealthStatusReporting;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSourceWithFailover;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.OutageTolerantJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RateLimitedJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RefreshAheadCachingJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.RetryingJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.URLBasedJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.DefaultResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.events.EventListener;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.health.HealthReportListener;

public class JWKSourceBuilder<C extends SecurityContext> {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    public static final long DEFAULT_CACHE_TIME_TO_LIVE = 300000L;
    public static final long DEFAULT_CACHE_REFRESH_TIMEOUT = 15000L;
    public static final long DEFAULT_REFRESH_AHEAD_TIME = 30000L;
    public static final long DEFAULT_RATE_LIMIT_MIN_INTERVAL = 30000L;
    private final JWKSetSource<C> jwkSetSource;
    private boolean caching = true;
    private long cacheTimeToLive = 300000L;
    private long cacheRefreshTimeout = 15000L;
    private EventListener<CachingJWKSetSource<C>, C> cachingEventListener;
    private boolean refreshAhead = true;
    private long refreshAheadTime = 30000L;
    private boolean refreshAheadScheduled = false;
    private boolean rateLimited = true;
    private long minTimeInterval = 30000L;
    private EventListener<RateLimitedJWKSetSource<C>, C> rateLimitedEventListener;
    private boolean retrying = false;
    private EventListener<RetryingJWKSetSource<C>, C> retryingEventListener;
    private boolean outageTolerant = false;
    private long outageCacheTimeToLive = -1L;
    private EventListener<OutageTolerantJWKSetSource<C>, C> outageEventListener;
    private HealthReportListener<JWKSetSourceWithHealthStatusReporting<C>, C> healthReportListener;
    protected JWKSource<C> failover;

    public static <C extends SecurityContext> JWKSourceBuilder<C> create(URL uRL) {
        DefaultResourceRetriever defaultResourceRetriever = new DefaultResourceRetriever(500, 500, 51200);
        URLBasedJWKSetSource uRLBasedJWKSetSource = new URLBasedJWKSetSource(uRL, defaultResourceRetriever);
        return new JWKSourceBuilder(uRLBasedJWKSetSource);
    }

    public static <C extends SecurityContext> JWKSourceBuilder<C> create(URL uRL, ResourceRetriever resourceRetriever) {
        return new JWKSourceBuilder(new URLBasedJWKSetSource(uRL, resourceRetriever));
    }

    public static <C extends SecurityContext> JWKSourceBuilder<C> create(JWKSetSource<C> jWKSetSource) {
        return new JWKSourceBuilder<C>(jWKSetSource);
    }

    private JWKSourceBuilder(JWKSetSource<C> jWKSetSource) {
        Objects.requireNonNull(jWKSetSource);
        this.jwkSetSource = jWKSetSource;
    }

    public JWKSourceBuilder<C> cache(boolean bl2) {
        this.caching = bl2;
        return this;
    }

    public JWKSourceBuilder<C> cache(long l2, long l3) {
        this.caching = true;
        this.cacheTimeToLive = l2;
        this.cacheRefreshTimeout = l3;
        return this;
    }

    public JWKSourceBuilder<C> cache(long l2, long l3, EventListener<CachingJWKSetSource<C>, C> eventListener) {
        this.caching = true;
        this.cacheTimeToLive = l2;
        this.cacheRefreshTimeout = l3;
        this.cachingEventListener = eventListener;
        return this;
    }

    public JWKSourceBuilder<C> cacheForever() {
        this.caching = true;
        this.cacheTimeToLive = Long.MAX_VALUE;
        this.refreshAhead = false;
        return this;
    }

    public JWKSourceBuilder<C> refreshAheadCache(boolean bl2) {
        if (bl2) {
            this.caching = true;
        }
        this.refreshAhead = bl2;
        return this;
    }

    public JWKSourceBuilder<C> refreshAheadCache(long l2, boolean bl2) {
        this.caching = true;
        this.refreshAhead = true;
        this.refreshAheadTime = l2;
        this.refreshAheadScheduled = bl2;
        return this;
    }

    public JWKSourceBuilder<C> refreshAheadCache(long l2, boolean bl2, EventListener<CachingJWKSetSource<C>, C> eventListener) {
        this.caching = true;
        this.refreshAhead = true;
        this.refreshAheadTime = l2;
        this.refreshAheadScheduled = bl2;
        this.cachingEventListener = eventListener;
        return this;
    }

    public JWKSourceBuilder<C> rateLimited(boolean bl2) {
        this.rateLimited = bl2;
        return this;
    }

    public JWKSourceBuilder<C> rateLimited(long l2) {
        this.rateLimited = true;
        this.minTimeInterval = l2;
        return this;
    }

    public JWKSourceBuilder<C> rateLimited(long l2, EventListener<RateLimitedJWKSetSource<C>, C> eventListener) {
        this.rateLimited = true;
        this.minTimeInterval = l2;
        this.rateLimitedEventListener = eventListener;
        return this;
    }

    public JWKSourceBuilder<C> failover(JWKSource<C> jWKSource) {
        this.failover = jWKSource;
        return this;
    }

    public JWKSourceBuilder<C> retrying(boolean bl2) {
        this.retrying = bl2;
        return this;
    }

    public JWKSourceBuilder<C> retrying(EventListener<RetryingJWKSetSource<C>, C> eventListener) {
        this.retrying = true;
        this.retryingEventListener = eventListener;
        return this;
    }

    public JWKSourceBuilder<C> healthReporting(HealthReportListener<JWKSetSourceWithHealthStatusReporting<C>, C> healthReportListener) {
        this.healthReportListener = healthReportListener;
        return this;
    }

    public JWKSourceBuilder<C> outageTolerant(boolean bl2) {
        this.outageTolerant = bl2;
        return this;
    }

    public JWKSourceBuilder<C> outageTolerantForever() {
        this.outageTolerant = true;
        this.outageCacheTimeToLive = Long.MAX_VALUE;
        return this;
    }

    public JWKSourceBuilder<C> outageTolerant(long l2) {
        this.outageTolerant = true;
        this.outageCacheTimeToLive = l2;
        return this;
    }

    public JWKSourceBuilder<C> outageTolerant(long l2, EventListener<OutageTolerantJWKSetSource<C>, C> eventListener) {
        this.outageTolerant = true;
        this.outageCacheTimeToLive = l2;
        this.outageEventListener = eventListener;
        return this;
    }

    public JWKSource<C> build() {
        if (!this.caching && this.rateLimited) {
            throw new IllegalStateException("Rate limiting requires caching");
        }
        if (!this.caching && this.refreshAhead) {
            throw new IllegalStateException("Refresh-ahead caching requires general caching");
        }
        if (this.caching && this.rateLimited && this.cacheTimeToLive <= this.minTimeInterval) {
            throw new IllegalStateException("The rate limiting min time interval between requests must be less than the cache time-to-live");
        }
        if (this.caching && this.outageTolerant && this.cacheTimeToLive == Long.MAX_VALUE && this.outageCacheTimeToLive == Long.MAX_VALUE) {
            throw new IllegalStateException("Outage tolerance not necessary with a non-expiring cache");
        }
        if (this.caching && this.refreshAhead && this.cacheTimeToLive == Long.MAX_VALUE) {
            throw new IllegalStateException("Refresh-ahead caching not necessary with a non-expiring cache");
        }
        JWKSetSource<C> jWKSetSource = this.jwkSetSource;
        if (this.retrying) {
            jWKSetSource = new RetryingJWKSetSource<C>(jWKSetSource, this.retryingEventListener);
        }
        if (this.outageTolerant) {
            if (this.outageCacheTimeToLive == -1L) {
                this.outageCacheTimeToLive = this.caching ? this.cacheTimeToLive * 10L : 3000000L;
            }
            jWKSetSource = new OutageTolerantJWKSetSource<C>(jWKSetSource, this.outageCacheTimeToLive, this.outageEventListener);
        }
        if (this.healthReportListener != null) {
            jWKSetSource = new JWKSetSourceWithHealthStatusReporting<C>(jWKSetSource, this.healthReportListener);
        }
        if (this.rateLimited) {
            jWKSetSource = new RateLimitedJWKSetSource<C>(jWKSetSource, this.minTimeInterval, this.rateLimitedEventListener);
        }
        if (this.refreshAhead) {
            jWKSetSource = new RefreshAheadCachingJWKSetSource<C>(jWKSetSource, this.cacheTimeToLive, this.cacheRefreshTimeout, this.refreshAheadTime, this.refreshAheadScheduled, this.cachingEventListener);
        } else if (this.caching) {
            jWKSetSource = new CachingJWKSetSource<C>(jWKSetSource, this.cacheTimeToLive, this.cacheRefreshTimeout, this.cachingEventListener);
        }
        JWKSetBasedJWKSource<C> jWKSetBasedJWKSource = new JWKSetBasedJWKSource<C>(jWKSetSource);
        if (this.failover != null) {
            return new JWKSourceWithFailover<C>(jWKSetBasedJWKSource, this.failover);
        }
        return jWKSetBasedJWKSource;
    }
}

