/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;

@ThreadSafe
public class JWKSetBasedJWKSource<C extends SecurityContext>
implements JWKSource<C>,
Closeable {
    private final JWKSetSource<C> source;

    public JWKSetBasedJWKSource(JWKSetSource<C> jWKSetSource) {
        Objects.requireNonNull(jWKSetSource);
        this.source = jWKSetSource;
    }

    @Override
    public List<JWK> get(JWKSelector jWKSelector, C c2) throws KeySourceException {
        long l2 = System.currentTimeMillis();
        JWKSet jWKSet = this.source.getJWKSet(JWKSetCacheRefreshEvaluator.noRefresh(), l2, c2);
        List<JWK> list = jWKSelector.select(jWKSet);
        if (list.isEmpty()) {
            JWKSet jWKSet2 = this.source.getJWKSet(JWKSetCacheRefreshEvaluator.referenceComparison(jWKSet), l2, c2);
            list = jWKSelector.select(jWKSet2);
        }
        return list;
    }

    public JWKSetSource<C> getJWKSetSource() {
        return this.source;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

