/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen;

import java.security.SecureRandom;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetSequenceKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen.JWKGenerator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

public class OctetSequenceKeyGenerator
extends JWKGenerator<OctetSequenceKey> {
    public static final int MIN_KEY_SIZE_BITS = 112;
    private final int size;

    public OctetSequenceKeyGenerator(int n2) {
        if (n2 < 112) {
            throw new IllegalArgumentException("The key size must be at least 112 bits");
        }
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("The key size in bits must be divisible by 8");
        }
        this.size = n2;
    }

    @Override
    public OctetSequenceKey generate() throws JOSEException {
        byte[] byArray = new byte[this.size / 8];
        if (this.secureRandom != null) {
            this.secureRandom.nextBytes(byArray);
        } else {
            new SecureRandom().nextBytes(byArray);
        }
        OctetSequenceKey.Builder builder = new OctetSequenceKey.Builder(Base64URL.encode(byArray)).keyUse(this.use).keyOperations(this.ops).algorithm(this.alg).keyStore(this.keyStore);
        if (this.x5tKid) {
            builder.keyIDFromThumbprint();
        } else {
            builder.keyID(this.kid);
        }
        return builder.build();
    }
}

