/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen;

import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;

public abstract class JWKGenerator<T extends JWK> {
    protected KeyUse use;
    protected Set<KeyOperation> ops;
    protected Algorithm alg;
    protected String kid;
    protected boolean x5tKid;
    protected Date exp;
    protected Date nbf;
    protected Date iat;
    protected KeyStore keyStore;
    protected Provider provider;
    protected SecureRandom secureRandom;

    public JWKGenerator<T> keyUse(KeyUse keyUse) {
        this.use = keyUse;
        return this;
    }

    public JWKGenerator<T> keyOperations(Set<KeyOperation> set) {
        this.ops = set;
        return this;
    }

    public JWKGenerator<T> algorithm(Algorithm algorithm) {
        this.alg = algorithm;
        return this;
    }

    public JWKGenerator<T> keyID(String string) {
        this.kid = string;
        return this;
    }

    public JWKGenerator<T> keyIDFromThumbprint(boolean bl2) {
        this.x5tKid = bl2;
        return this;
    }

    public JWKGenerator<T> expirationTime(Date date) {
        this.exp = date;
        return this;
    }

    public JWKGenerator<T> notBeforeTime(Date date) {
        this.nbf = date;
        return this;
    }

    public JWKGenerator<T> issueTime(Date date) {
        this.iat = date;
        return this;
    }

    public JWKGenerator<T> keyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public JWKGenerator<T> provider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public JWKGenerator<T> secureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public abstract T generate() throws JOSEException;
}

