/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.io.Serializable;
import java.net.URI;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyRevocation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUseAndOpsConsistency;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetSequenceKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.PEMEncodedKeyParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ThumbprintURI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ThumbprintUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertChainUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;

public abstract class JWK
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE = "application/jwk+json; charset=UTF-8";
    private final KeyType kty;
    private final KeyUse use;
    private final Set<KeyOperation> ops;
    private final Algorithm alg;
    private final String kid;
    private final URI x5u;
    @Deprecated
    private final Base64URL x5t;
    private final Base64URL x5t256;
    private final List<Base64> x5c;
    private final Date exp;
    private final Date nbf;
    private final Date iat;
    private final KeyRevocation revocation;
    private final List<X509Certificate> parsedX5c;
    private final KeyStore keyStore;

    @Deprecated
    protected JWK(KeyType keyType, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(keyType, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    protected JWK(KeyType keyType, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(keyType, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, null, keyStore);
    }

    protected JWK(KeyType keyType, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this.kty = Objects.requireNonNull(keyType, "The key type \"kty\" parameter must not be null");
        if (!KeyUseAndOpsConsistency.areConsistent(keyUse, set)) {
            throw new IllegalArgumentException("The key use \"use\" and key options \"key_ops\" parameters are not consistent, see RFC 7517, section 4.3");
        }
        this.use = keyUse;
        this.ops = set;
        this.alg = algorithm;
        this.kid = string;
        this.x5u = uRI;
        this.x5t = base64URL;
        this.x5t256 = base64URL2;
        if (list != null && list.isEmpty()) {
            throw new IllegalArgumentException("The X.509 certificate chain \"x5c\" must not be empty");
        }
        this.x5c = list;
        try {
            this.parsedX5c = X509CertChainUtils.parse(list);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid X.509 certificate chain \"x5c\": " + parseException.getMessage(), parseException);
        }
        this.exp = date;
        this.nbf = date2;
        this.iat = date3;
        this.revocation = keyRevocation;
        this.keyStore = keyStore;
    }

    public KeyType getKeyType() {
        return this.kty;
    }

    public KeyUse getKeyUse() {
        return this.use;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.ops;
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public String getKeyID() {
        return this.kid;
    }

    public URI getX509CertURL() {
        return this.x5u;
    }

    @Deprecated
    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public Base64URL getX509CertSHA256Thumbprint() {
        return this.x5t256;
    }

    public List<Base64> getX509CertChain() {
        if (this.x5c == null) {
            return null;
        }
        return Collections.unmodifiableList(this.x5c);
    }

    public List<X509Certificate> getParsedX509CertChain() {
        if (this.parsedX5c == null) {
            return null;
        }
        return Collections.unmodifiableList(this.parsedX5c);
    }

    public Date getExpirationTime() {
        return this.exp;
    }

    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public Date getIssueTime() {
        return this.iat;
    }

    public KeyRevocation getKeyRevocation() {
        return this.revocation;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public abstract LinkedHashMap<String, ?> getRequiredParams();

    public Base64URL computeThumbprint() throws JOSEException {
        return this.computeThumbprint("SHA-256");
    }

    public Base64URL computeThumbprint(String string) throws JOSEException {
        return ThumbprintUtils.compute(string, this);
    }

    public ThumbprintURI computeThumbprintURI() throws JOSEException {
        return new ThumbprintURI("sha-256", this.computeThumbprint("SHA-256"));
    }

    public abstract boolean isPrivate();

    public abstract JWK toPublicJWK();

    public abstract int size();

    public RSAKey toRSAKey() {
        return (RSAKey)this;
    }

    public ECKey toECKey() {
        return (ECKey)this;
    }

    public OctetSequenceKey toOctetSequenceKey() {
        return (OctetSequenceKey)this;
    }

    public OctetKeyPair toOctetKeyPair() {
        return (OctetKeyPair)this;
    }

    public Map<String, Object> toJSONObject() {
        List<Object> list;
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.put("kty", this.kty.getValue());
        if (this.use != null) {
            map.put("use", this.use.identifier());
        }
        if (this.ops != null) {
            list = JSONArrayUtils.newJSONArray();
            for (KeyOperation object : this.ops) {
                list.add(object.identifier());
            }
            map.put("key_ops", list);
        }
        if (this.alg != null) {
            map.put("alg", this.alg.getName());
        }
        if (this.kid != null) {
            map.put("kid", this.kid);
        }
        if (this.x5u != null) {
            map.put("x5u", this.x5u.toString());
        }
        if (this.x5t != null) {
            map.put("x5t", this.x5t.toString());
        }
        if (this.x5t256 != null) {
            map.put("x5t#S256", this.x5t256.toString());
        }
        if (this.x5c != null) {
            list = JSONArrayUtils.newJSONArray();
            for (Base64 base64 : this.x5c) {
                list.add(base64.toString());
            }
            map.put("x5c", list);
        }
        if (this.exp != null) {
            map.put("exp", DateUtils.toSecondsSinceEpoch(this.exp));
        }
        if (this.nbf != null) {
            map.put("nbf", DateUtils.toSecondsSinceEpoch(this.nbf));
        }
        if (this.iat != null) {
            map.put("iat", DateUtils.toSecondsSinceEpoch(this.iat));
        }
        if (this.revocation != null) {
            map.put("revoked", this.revocation.toJSONObject());
        }
        return map;
    }

    public String toJSONString() {
        return JSONObjectUtils.toJSONString(this.toJSONObject());
    }

    public String toString() {
        return JSONObjectUtils.toJSONString(this.toJSONObject());
    }

    public static JWK parse(String string) throws ParseException {
        return JWK.parse(JSONObjectUtils.parse(string));
    }

    public static JWK parse(Map<String, Object> map) throws ParseException {
        String string = JSONObjectUtils.getString(map, "kty");
        if (string == null) {
            throw new ParseException("Missing key type \"kty\" parameter", 0);
        }
        KeyType keyType = KeyType.parse(string);
        if (keyType == KeyType.EC) {
            return ECKey.parse(map);
        }
        if (keyType == KeyType.RSA) {
            return RSAKey.parse(map);
        }
        if (keyType == KeyType.OCT) {
            return OctetSequenceKey.parse(map);
        }
        if (keyType == KeyType.OKP) {
            return OctetKeyPair.parse(map);
        }
        throw new ParseException("Unsupported key type \"kty\" parameter: " + keyType, 0);
    }

    public static JWK parse(X509Certificate x509Certificate) throws JOSEException {
        if (x509Certificate.getPublicKey() instanceof RSAPublicKey) {
            return RSAKey.parse(x509Certificate);
        }
        if (x509Certificate.getPublicKey() instanceof ECPublicKey) {
            return ECKey.parse(x509Certificate);
        }
        throw new JOSEException("Unsupported public key algorithm: " + x509Certificate.getPublicKey().getAlgorithm());
    }

    public static JWK parseFromPEMEncodedX509Cert(String string) throws JOSEException {
        X509Certificate x509Certificate = X509CertUtils.parse(string);
        if (x509Certificate == null) {
            throw new JOSEException("Couldn't parse PEM-encoded X.509 certificate");
        }
        return JWK.parse(x509Certificate);
    }

    public static JWK load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate == null) {
            return OctetSequenceKey.load(keyStore, string, cArray);
        }
        if (certificate.getPublicKey() instanceof RSAPublicKey) {
            return RSAKey.load(keyStore, string, cArray);
        }
        if (certificate.getPublicKey() instanceof ECPublicKey) {
            return ECKey.load(keyStore, string, cArray);
        }
        throw new JOSEException("Unsupported public key algorithm: " + certificate.getPublicKey().getAlgorithm());
    }

    public static JWK parseFromPEMEncodedObjects(String string) throws JOSEException {
        List<KeyPair> list = PEMEncodedKeyParser.parseKeys(string);
        if (list.isEmpty()) {
            throw new JOSEException("No PEM-encoded keys found");
        }
        KeyPair keyPair = JWK.mergeKeyPairs(list);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        if (publicKey == null) {
            throw new JOSEException("Missing PEM-encoded public key to construct JWK");
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)publicKey;
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            if (privateKey instanceof ECPrivateKey) {
                JWK.validateEcCurves(eCPublicKey, (ECPrivateKey)privateKey);
            }
            if (privateKey != null && !(privateKey instanceof ECPrivateKey)) {
                throw new JOSEException("Unsupported " + KeyType.EC.getValue() + " private key type: " + privateKey);
            }
            Curve curve = Curve.forECParameterSpec(eCParameterSpec);
            ECKey.Builder builder = new ECKey.Builder(curve, (ECPublicKey)publicKey);
            if (privateKey != null) {
                builder.privateKey((ECPrivateKey)privateKey);
            }
            return builder.build();
        }
        if (publicKey instanceof RSAPublicKey) {
            RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)publicKey);
            if (privateKey instanceof RSAPrivateKey) {
                builder.privateKey((RSAPrivateKey)privateKey);
            } else if (privateKey != null) {
                throw new JOSEException("Unsupported " + KeyType.RSA.getValue() + " private key type: " + privateKey);
            }
            return builder.build();
        }
        throw new JOSEException("Unsupported algorithm of PEM-encoded key: " + publicKey.getAlgorithm());
    }

    private static void validateEcCurves(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws JOSEException {
        ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
        ECParameterSpec eCParameterSpec2 = eCPrivateKey.getParams();
        if (!eCParameterSpec.getCurve().equals(eCParameterSpec2.getCurve())) {
            throw new JOSEException("Public/private " + KeyType.EC.getValue() + " key curve mismatch: " + eCPublicKey);
        }
        if (eCParameterSpec.getCofactor() != eCParameterSpec2.getCofactor()) {
            throw new JOSEException("Public/private " + KeyType.EC.getValue() + " key cofactor mismatch: " + eCPublicKey);
        }
        if (!eCParameterSpec.getGenerator().equals(eCParameterSpec2.getGenerator())) {
            throw new JOSEException("Public/private " + KeyType.EC.getValue() + " key generator mismatch: " + eCPublicKey);
        }
        if (!eCParameterSpec.getOrder().equals(eCParameterSpec2.getOrder())) {
            throw new JOSEException("Public/private " + KeyType.EC.getValue() + " key order mismatch: " + eCPublicKey);
        }
    }

    private static KeyPair mergeKeyPairs(List<KeyPair> list) throws JOSEException {
        KeyPair keyPair;
        if (list.size() == 1) {
            keyPair = list.get(0);
        } else if (list.size() == 2) {
            keyPair = JWK.twoKeysToKeyPair(list);
        } else {
            throw new JOSEException("Expected key or pair of PEM-encoded keys");
        }
        return keyPair;
    }

    private static KeyPair twoKeysToKeyPair(List<? extends KeyPair> list) throws JOSEException {
        KeyPair keyPair = list.get(0);
        KeyPair keyPair2 = list.get(1);
        if (keyPair.getPublic() != null && keyPair2.getPrivate() != null) {
            return new KeyPair(keyPair.getPublic(), keyPair2.getPrivate());
        }
        if (keyPair.getPrivate() != null && keyPair2.getPublic() != null) {
            return new KeyPair(keyPair2.getPublic(), keyPair.getPrivate());
        }
        throw new JOSEException("Not a public/private key pair");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JWK)) {
            return false;
        }
        JWK jWK = (JWK)object;
        return Objects.equals(this.kty, jWK.kty) && Objects.equals(this.use, jWK.use) && Objects.equals(this.ops, jWK.ops) && Objects.equals(this.alg, jWK.alg) && Objects.equals(this.kid, jWK.kid) && Objects.equals(this.x5u, jWK.x5u) && Objects.equals(this.x5t, jWK.x5t) && Objects.equals(this.x5t256, jWK.x5t256) && Objects.equals(this.x5c, jWK.x5c) && Objects.equals(this.exp, jWK.exp) && Objects.equals(this.nbf, jWK.nbf) && Objects.equals(this.iat, jWK.iat) && Objects.equals(this.revocation, jWK.revocation) && Objects.equals(this.keyStore, jWK.keyStore);
    }

    public int hashCode() {
        return Objects.hash(this.kty, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.exp, this.nbf, this.iat, this.revocation, this.keyStore);
    }
}

