/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.util.Collections;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Header;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;

public class CriticalHeaderParamsDeferral {
    private Set<String> deferredParams = Collections.emptySet();

    public Set<String> getProcessedCriticalHeaderParams() {
        return Collections.singleton("b64");
    }

    public Set<String> getDeferredCriticalHeaderParams() {
        return Collections.unmodifiableSet(this.deferredParams);
    }

    public void setDeferredCriticalHeaderParams(Set<String> set) {
        this.deferredParams = set == null ? Collections.emptySet() : set;
    }

    public boolean headerPasses(Header header) {
        if (header.getCriticalParams() == null) {
            return true;
        }
        for (String string : header.getCriticalParams()) {
            if (this.getProcessedCriticalHeaderParams().contains(string) || this.getDeferredCriticalHeaderParams().contains(string)) continue;
            return false;
        }
        return true;
    }

    public void ensureHeaderPasses(JWEHeader jWEHeader) throws JOSEException {
        if (!this.headerPasses(jWEHeader)) {
            throw new JOSEException("Unsupported critical header parameter(s)");
        }
    }
}

