/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESCBC;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESGCM;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.DeflateHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.XC20P;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca.JWEJCAContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Container;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IntegerOverflowException;

public class ContentCryptoProvider {
    public static final Set<EncryptionMethod> SUPPORTED_ENCRYPTION_METHODS;
    public static final Map<Integer, Set<EncryptionMethod>> COMPATIBLE_ENCRYPTION_METHODS;

    public static SecretKey generateCEK(EncryptionMethod encryptionMethod, SecureRandom secureRandom) throws JOSEException {
        if (!SUPPORTED_ENCRYPTION_METHODS.contains(encryptionMethod)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod(encryptionMethod, SUPPORTED_ENCRYPTION_METHODS));
        }
        byte[] byArray = new byte[ByteUtils.byteLength(encryptionMethod.cekBitLength())];
        secureRandom.nextBytes(byArray);
        return new SecretKeySpec(byArray, "AES");
    }

    private static void checkCEKLength(SecretKey secretKey, EncryptionMethod encryptionMethod) throws KeyLengthException {
        int n2;
        try {
            n2 = ByteUtils.safeBitLength(secretKey.getEncoded());
        }
        catch (IntegerOverflowException integerOverflowException) {
            throw new KeyLengthException("The Content Encryption Key (CEK) is too long: " + integerOverflowException.getMessage());
        }
        if (n2 == 0) {
            return;
        }
        if (encryptionMethod.cekBitLength() != n2) {
            throw new KeyLengthException("The Content Encryption Key (CEK) length for " + encryptionMethod + " must be " + encryptionMethod.cekBitLength() + " bits");
        }
    }

    public static JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray, SecretKey secretKey, Base64URL base64URL, JWEJCAContext jWEJCAContext) throws JOSEException {
        return ContentCryptoProvider.encrypt(jWEHeader, byArray, null, secretKey, base64URL, jWEJCAContext);
    }

    public static JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray, byte[] byArray2, SecretKey secretKey, Base64URL base64URL, JWEJCAContext jWEJCAContext) throws JOSEException {
        AuthenticatedCipherText authenticatedCipherText;
        byte[] byArray3;
        if (byArray2 == null) {
            return ContentCryptoProvider.encrypt(jWEHeader, byArray, AAD.compute(jWEHeader), secretKey, base64URL, jWEJCAContext);
        }
        ContentCryptoProvider.checkCEKLength(secretKey, jWEHeader.getEncryptionMethod());
        byte[] byArray4 = DeflateHelper.applyCompression(jWEHeader, byArray);
        if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A128CBC_HS256) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A192CBC_HS384) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A256CBC_HS512)) {
            byArray3 = AESCBC.generateIV(jWEJCAContext.getSecureRandom());
            authenticatedCipherText = AESCBC.encryptAuthenticated(secretKey, byArray3, byArray4, byArray2, jWEJCAContext.getContentEncryptionProvider(), jWEJCAContext.getMACProvider());
        } else if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A128GCM) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A192GCM) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A256GCM)) {
            Container<byte[]> container = new Container<byte[]>(AESGCM.generateIV(jWEJCAContext.getSecureRandom()));
            authenticatedCipherText = AESGCM.encrypt(secretKey, container, byArray4, byArray2, jWEJCAContext.getContentEncryptionProvider());
            byArray3 = container.get();
        } else if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A128CBC_HS256_DEPRECATED) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            byArray3 = AESCBC.generateIV(jWEJCAContext.getSecureRandom());
            authenticatedCipherText = AESCBC.encryptWithConcatKDF(jWEHeader, secretKey, base64URL, byArray3, byArray4, jWEJCAContext.getContentEncryptionProvider(), jWEJCAContext.getMACProvider());
        } else if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.XC20P)) {
            Container<Object> container = new Container<Object>(null);
            authenticatedCipherText = XC20P.encryptAuthenticated(secretKey, container, byArray4, byArray2);
            byArray3 = container.get();
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod(jWEHeader.getEncryptionMethod(), SUPPORTED_ENCRYPTION_METHODS));
        }
        return new JWECryptoParts(jWEHeader, base64URL, Base64URL.encode(byArray3), Base64URL.encode(authenticatedCipherText.getCipherText()), Base64URL.encode(authenticatedCipherText.getAuthenticationTag()));
    }

    public static byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, SecretKey secretKey, JWEJCAContext jWEJCAContext) throws JOSEException {
        return ContentCryptoProvider.decrypt(jWEHeader, null, base64URL, base64URL2, base64URL3, base64URL4, secretKey, jWEJCAContext);
    }

    public static byte[] decrypt(JWEHeader jWEHeader, byte[] byArray, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, SecretKey secretKey, JWEJCAContext jWEJCAContext) throws JOSEException {
        byte[] byArray2;
        if (byArray == null) {
            return ContentCryptoProvider.decrypt(jWEHeader, AAD.compute(jWEHeader), base64URL, base64URL2, base64URL3, base64URL4, secretKey, jWEJCAContext);
        }
        ContentCryptoProvider.checkCEKLength(secretKey, jWEHeader.getEncryptionMethod());
        if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A128CBC_HS256) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A192CBC_HS384) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A256CBC_HS512)) {
            byArray2 = AESCBC.decryptAuthenticated(secretKey, base64URL2.decode(), base64URL3.decode(), byArray, base64URL4.decode(), jWEJCAContext.getContentEncryptionProvider(), jWEJCAContext.getMACProvider());
        } else if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A128GCM) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A192GCM) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A256GCM)) {
            byArray2 = AESGCM.decrypt(secretKey, base64URL2.decode(), base64URL3.decode(), byArray, base64URL4.decode(), jWEJCAContext.getContentEncryptionProvider());
        } else if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A128CBC_HS256_DEPRECATED) || jWEHeader.getEncryptionMethod().equals(EncryptionMethod.A256CBC_HS512_DEPRECATED)) {
            byArray2 = AESCBC.decryptWithConcatKDF(jWEHeader, secretKey, base64URL, base64URL2, base64URL3, base64URL4, jWEJCAContext.getContentEncryptionProvider(), jWEJCAContext.getMACProvider());
        } else if (jWEHeader.getEncryptionMethod().equals(EncryptionMethod.XC20P)) {
            byArray2 = XC20P.decryptAuthenticated(secretKey, base64URL2.decode(), base64URL3.decode(), byArray, base64URL4.decode());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedEncryptionMethod(jWEHeader.getEncryptionMethod(), SUPPORTED_ENCRYPTION_METHODS));
        }
        return DeflateHelper.applyDecompression(jWEHeader, byArray2);
    }

    static {
        LinkedHashSet<EncryptionMethod> linkedHashSet = new LinkedHashSet<EncryptionMethod>();
        linkedHashSet.add(EncryptionMethod.A128CBC_HS256);
        linkedHashSet.add(EncryptionMethod.A192CBC_HS384);
        linkedHashSet.add(EncryptionMethod.A256CBC_HS512);
        linkedHashSet.add(EncryptionMethod.A128GCM);
        linkedHashSet.add(EncryptionMethod.A192GCM);
        linkedHashSet.add(EncryptionMethod.A256GCM);
        linkedHashSet.add(EncryptionMethod.A128CBC_HS256_DEPRECATED);
        linkedHashSet.add(EncryptionMethod.A256CBC_HS512_DEPRECATED);
        linkedHashSet.add(EncryptionMethod.XC20P);
        SUPPORTED_ENCRYPTION_METHODS = Collections.unmodifiableSet(linkedHashSet);
        HashMap hashMap = new HashMap();
        HashSet<EncryptionMethod> hashSet = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet2 = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet3 = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet4 = new HashSet<EncryptionMethod>();
        HashSet<EncryptionMethod> hashSet5 = new HashSet<EncryptionMethod>();
        hashSet.add(EncryptionMethod.A128GCM);
        hashSet2.add(EncryptionMethod.A192GCM);
        hashSet3.add(EncryptionMethod.A256GCM);
        hashSet3.add(EncryptionMethod.A128CBC_HS256);
        hashSet3.add(EncryptionMethod.A128CBC_HS256_DEPRECATED);
        hashSet3.add(EncryptionMethod.XC20P);
        hashSet4.add(EncryptionMethod.A192CBC_HS384);
        hashSet5.add(EncryptionMethod.A256CBC_HS512);
        hashSet5.add(EncryptionMethod.A256CBC_HS512_DEPRECATED);
        hashMap.put(128, Collections.unmodifiableSet(hashSet));
        hashMap.put(192, Collections.unmodifiableSet(hashSet2));
        hashMap.put(256, Collections.unmodifiableSet(hashSet3));
        hashMap.put(384, Collections.unmodifiableSet(hashSet4));
        hashMap.put(512, Collections.unmodifiableSet(hashSet5));
        COMPATIBLE_ENCRYPTION_METHODS = Collections.unmodifiableMap(hashMap);
    }
}

