/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA1_5;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSACryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA_OAEP;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA_OAEP_SHA2;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class RSAEncrypter
extends RSACryptoProvider
implements JWEEncrypter {
    private final RSAPublicKey publicKey;

    public RSAEncrypter(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, null);
    }

    public RSAEncrypter(RSAKey rSAKey) throws JOSEException {
        this(rSAKey.toRSAPublicKey());
    }

    public RSAEncrypter(RSAPublicKey rSAPublicKey, SecretKey secretKey) {
        super(secretKey);
        this.publicKey = Objects.requireNonNull(rSAPublicKey);
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        return this.encrypt(jWEHeader, byArray, AAD.compute(jWEHeader));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray, byte[] byArray2) throws JOSEException {
        Base64URL base64URL;
        JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader);
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        SecretKey secretKey = this.getCEK(encryptionMethod);
        if (jWEAlgorithm.equals(JWEAlgorithm.RSA1_5)) {
            base64URL = Base64URL.encode(RSA1_5.encryptCEK(this.publicKey, secretKey, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP)) {
            base64URL = Base64URL.encode(RSA_OAEP.encryptCEK(this.publicKey, secretKey, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_256)) {
            base64URL = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, secretKey, 256, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_384)) {
            base64URL = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, secretKey, 384, this.getJCAContext().getKeyEncryptionProvider()));
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_512)) {
            base64URL = Base64URL.encode(RSA_OAEP_SHA2.encryptCEK(this.publicKey, secretKey, 512, this.getJCAContext().getKeyEncryptionProvider()));
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(jWEAlgorithm, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.encrypt(jWEHeader, byArray, byArray2, secretKey, base64URL, this.getJCAContext());
    }
}

