/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.UnprotectedHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.AESEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.DirectEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.ECDHEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.RSAEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.X25519Encrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.BaseJWEProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.MultiCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

@ThreadSafe
public class MultiEncrypter
extends MultiCryptoProvider
implements JWEEncrypter {
    private static final String[] RECIPIENT_HEADER_PARAMS = new String[]{"kid", "alg", "x5u", "x5t", "x5t#S256", "x5c"};
    private final JWKSet keys;

    public MultiEncrypter(JWKSet jWKSet) throws KeyLengthException {
        this(jWKSet, MultiEncrypter.findDirectCEK(jWKSet));
    }

    public MultiEncrypter(JWKSet jWKSet, SecretKey secretKey) throws KeyLengthException {
        super(secretKey);
        for (JWK jWK : jWKSet.getKeys()) {
            KeyType keyType = jWK.getKeyType();
            if (jWK.getAlgorithm() == null) {
                throw new IllegalArgumentException("Each JWK must specify a key encryption algorithm");
            }
            JWEAlgorithm jWEAlgorithm = JWEAlgorithm.parse(jWK.getAlgorithm().toString());
            if (JWEAlgorithm.DIR.equals(jWEAlgorithm) && KeyType.OCT.equals(keyType) && !jWK.toOctetSequenceKey().toSecretKey("AES").equals(secretKey)) {
                throw new IllegalArgumentException("Bad CEK");
            }
            if (KeyType.RSA.equals(keyType) && RSAEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm) || KeyType.EC.equals(keyType) && ECDHEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm) || KeyType.OCT.equals(keyType) && AESEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm) || KeyType.OCT.equals(keyType) && DirectEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm) || KeyType.OKP.equals(keyType) && X25519Encrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) continue;
            throw new IllegalArgumentException("Unsupported key encryption algorithm: " + jWEAlgorithm);
        }
        this.keys = jWKSet;
    }

    private static SecretKey findDirectCEK(JWKSet jWKSet) {
        if (jWKSet != null) {
            for (JWK jWK : jWKSet.getKeys()) {
                if (!JWEAlgorithm.DIR.equals(jWK.getAlgorithm()) || !KeyType.OCT.equals(jWK.getKeyType())) continue;
                return jWK.toOctetSequenceKey().toSecretKey("AES");
            }
        }
        return null;
    }

    @Deprecated
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        return this.encrypt(jWEHeader, byArray, AAD.compute(jWEHeader));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray, byte[] byArray2) throws JOSEException {
        if (byArray2 == null) {
            throw new JOSEException("Missing JWE additional authenticated data (AAD)");
        }
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        SecretKey secretKey = this.getCEK(encryptionMethod);
        JWEHeader jWEHeader2 = null;
        Base64URL base64URL = null;
        Base64URL base64URL2 = null;
        Base64URL base64URL3 = null;
        Base64URL base64URL4 = null;
        Payload payload = new Payload(byArray);
        List<Object> list = JSONArrayUtils.newJSONArray();
        for (JWK jWK : this.keys.getKeys()) {
            BaseJWEProvider baseJWEProvider;
            KeyType keyType = jWK.getKeyType();
            Map<String, Object> map = jWK.toJSONObject();
            UnprotectedHeader.Builder builder = new UnprotectedHeader.Builder();
            for (String string : RECIPIENT_HEADER_PARAMS) {
                if (!map.containsKey(string)) continue;
                builder.param(string, map.get(string));
            }
            try {
                jWEHeader2 = (JWEHeader)jWEHeader.join(builder.build());
            }
            catch (Exception exception) {
                throw new JOSEException(exception.getMessage(), exception);
            }
            JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader2);
            if (KeyType.RSA.equals(keyType) && RSAEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
                baseJWEProvider = new RSAEncrypter(jWK.toRSAKey().toRSAPublicKey(), secretKey);
            } else if (KeyType.EC.equals(keyType) && ECDHEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
                baseJWEProvider = new ECDHEncrypter(jWK.toECKey().toECPublicKey(), secretKey);
            } else if (KeyType.OCT.equals(keyType) && AESEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
                baseJWEProvider = new AESEncrypter(jWK.toOctetSequenceKey().toSecretKey("AES"), secretKey);
            } else if (KeyType.OCT.equals(keyType) && DirectEncrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) {
                baseJWEProvider = new DirectEncrypter(jWK.toOctetSequenceKey().toSecretKey("AES"));
            } else {
                if (!KeyType.OKP.equals(keyType) || !X25519Encrypter.SUPPORTED_ALGORITHMS.contains(jWEAlgorithm)) continue;
                baseJWEProvider = new X25519Encrypter(jWK.toOctetKeyPair().toPublicJWK(), secretKey);
            }
            JWECryptoParts jWECryptoParts = baseJWEProvider.encrypt(jWEHeader2, payload.toBytes(), byArray2);
            Map<String, Object> map2 = jWECryptoParts.getHeader().toJSONObject();
            for (String string : jWEHeader.getIncludedParams()) {
                map2.remove(string);
            }
            Map<String, Object> map3 = JSONObjectUtils.newJSONObject();
            map3.put("header", map2);
            if (!JWEAlgorithm.DIR.equals(jWEAlgorithm)) {
                map3.put("encrypted_key", jWECryptoParts.getEncryptedKey().toString());
            }
            list.add(map3);
            if (list.size() != 1) continue;
            payload = new Payload("");
            base64URL = jWECryptoParts.getEncryptedKey();
            base64URL3 = jWECryptoParts.getInitializationVector();
            base64URL2 = jWECryptoParts.getCipherText();
            base64URL4 = jWECryptoParts.getAuthenticationTag();
        }
        if (list.size() > 1) {
            Map<String, Object> map = JSONObjectUtils.newJSONObject();
            map.put("recipients", list);
            base64URL = Base64URL.encode(JSONObjectUtils.toJSONString(map));
        }
        return new JWECryptoParts(jWEHeader, base64URL, base64URL3, base64URL2, base64URL4);
    }
}

