/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Header;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

@Immutable
public final class PlainHeader
extends Header {
    private static final long serialVersionUID = 1L;
    private static final Set<String> REGISTERED_PARAMETER_NAMES;

    public PlainHeader() {
        this(null, null, null, null, null);
    }

    public PlainHeader(JOSEObjectType jOSEObjectType, String string, Set<String> set, Map<String, Object> map, Base64URL base64URL) {
        super(Algorithm.NONE, jOSEObjectType, string, set, map, base64URL);
    }

    public PlainHeader(PlainHeader plainHeader) {
        this(plainHeader.getType(), plainHeader.getContentType(), plainHeader.getCriticalParams(), plainHeader.getCustomParams(), plainHeader.getParsedBase64URL());
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    @Override
    public Algorithm getAlgorithm() {
        return Algorithm.NONE;
    }

    public static PlainHeader parse(Map<String, Object> map) throws ParseException {
        return PlainHeader.parse(map, null);
    }

    public static PlainHeader parse(Map<String, Object> map, Base64URL base64URL) throws ParseException {
        Algorithm algorithm = Header.parseAlgorithm(map);
        if (algorithm != Algorithm.NONE) {
            throw new ParseException("The algorithm \"alg\" header parameter must be \"none\"", 0);
        }
        Builder builder = new Builder().parsedBase64URL(base64URL);
        for (String string : map.keySet()) {
            List<String> list;
            if ("alg".equals(string)) continue;
            if ("typ".equals(string)) {
                list = JSONObjectUtils.getString(map, string);
                if (list == null) continue;
                builder = builder.type(new JOSEObjectType((String)((Object)list)));
                continue;
            }
            if ("cty".equals(string)) {
                builder = builder.contentType(JSONObjectUtils.getString(map, string));
                continue;
            }
            if ("crit".equals(string)) {
                list = JSONObjectUtils.getStringList(map, string);
                if (list == null) continue;
                builder = builder.criticalParams(new HashSet<String>(list));
                continue;
            }
            builder = builder.customParam(string, map.get(string));
        }
        return builder.build();
    }

    public static PlainHeader parse(String string) throws ParseException {
        return PlainHeader.parse(string, null);
    }

    public static PlainHeader parse(String string, Base64URL base64URL) throws ParseException {
        return PlainHeader.parse(JSONObjectUtils.parse(string, 20000), base64URL);
    }

    public static PlainHeader parse(Base64URL base64URL) throws ParseException {
        return PlainHeader.parse(base64URL.decodeToString(), base64URL);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("alg");
        hashSet.add("typ");
        hashSet.add("cty");
        hashSet.add("crit");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private JOSEObjectType typ;
        private String cty;
        private Set<String> crit;
        private Map<String, Object> customParams;
        private Base64URL parsedBase64URL;

        public Builder() {
        }

        public Builder(PlainHeader plainHeader) {
            this.typ = plainHeader.getType();
            this.cty = plainHeader.getContentType();
            this.crit = plainHeader.getCriticalParams();
            this.customParams = plainHeader.getCustomParams();
        }

        public Builder type(JOSEObjectType jOSEObjectType) {
            this.typ = jOSEObjectType;
            return this;
        }

        public Builder contentType(String string) {
            this.cty = string;
            return this;
        }

        public Builder criticalParams(Set<String> set) {
            this.crit = set;
            return this;
        }

        public Builder customParam(String string, Object object) {
            if (PlainHeader.getRegisteredParameterNames().contains(string)) {
                throw new IllegalArgumentException("The parameter name \"" + string + "\" matches a registered name");
            }
            if (this.customParams == null) {
                this.customParams = new HashMap<String, Object>();
            }
            this.customParams.put(string, object);
            return this;
        }

        public Builder customParams(Map<String, Object> map) {
            this.customParams = map;
            return this;
        }

        public Builder parsedBase64URL(Base64URL base64URL) {
            this.parsedBase64URL = base64URL;
            return this;
        }

        public PlainHeader build() {
            return new PlainHeader(this.typ, this.cty, this.crit, this.customParams, this.parsedBase64URL);
        }
    }
}

