/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.security.Signature;
import java.text.ParseException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.ActionRequiredForJWSCompletionException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CompletableJWSObjectSigning;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

@ThreadSafe
public class JWSObject
extends JOSEObject {
    private static final long serialVersionUID = 1L;
    private final JWSHeader header;
    private final String signingInputString;
    private Base64URL signature;
    private final AtomicReference<State> state = new AtomicReference();

    public JWSObject(JWSHeader jWSHeader, Payload payload) {
        this.header = Objects.requireNonNull(jWSHeader);
        this.setPayload(Objects.requireNonNull(payload));
        this.signingInputString = this.composeSigningInput();
        this.signature = null;
        this.state.set(State.UNSIGNED);
    }

    public JWSObject(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3) throws ParseException {
        this(base64URL, new Payload(base64URL2), base64URL3);
    }

    public JWSObject(Base64URL base64URL, Payload payload, Base64URL base64URL2) throws ParseException {
        try {
            this.header = JWSHeader.parse(base64URL);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid JWS header: " + parseException.getMessage(), 0);
        }
        this.setPayload(Objects.requireNonNull(payload));
        this.signingInputString = this.composeSigningInput();
        if (base64URL2.toString().trim().isEmpty()) {
            throw new ParseException("The signature must not be empty", 0);
        }
        this.signature = base64URL2;
        this.state.set(State.SIGNED);
        if (this.getHeader().isBase64URLEncodePayload()) {
            this.setParsedParts(base64URL, payload.toBase64URL(), base64URL2);
        } else {
            this.setParsedParts(base64URL, new Base64URL(""), base64URL2);
        }
    }

    @Override
    public JWSHeader getHeader() {
        return this.header;
    }

    private String composeSigningInput() {
        if (this.header.isBase64URLEncodePayload()) {
            return this.getHeader().toBase64URL().toString() + '.' + this.getPayload().toBase64URL().toString();
        }
        return this.getHeader().toBase64URL().toString() + '.' + this.getPayload().toString();
    }

    public byte[] getSigningInput() {
        return this.signingInputString.getBytes(StandardCharset.UTF_8);
    }

    public Base64URL getSignature() {
        return this.signature;
    }

    public State getState() {
        return this.state.get();
    }

    private void ensureUnsignedState() {
        if (this.state.get() != State.UNSIGNED) {
            throw new IllegalStateException("The JWS object must be in an unsigned state");
        }
    }

    private void ensureSignedOrVerifiedState() {
        if (this.state.get() != State.SIGNED && this.state.get() != State.VERIFIED) {
            throw new IllegalStateException("The JWS object must be in a signed or verified state");
        }
    }

    private void ensureJWSSignerSupport(JWSSigner jWSSigner) throws JOSEException {
        if (!jWSSigner.supportedJWSAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The " + this.getHeader().getAlgorithm() + " algorithm is not allowed or supported by the JWS signer: Supported algorithms: " + jWSSigner.supportedJWSAlgorithms());
        }
    }

    public synchronized void sign(JWSSigner jWSSigner) throws JOSEException {
        this.ensureUnsignedState();
        this.ensureJWSSignerSupport(jWSSigner);
        try {
            this.signature = jWSSigner.sign(this.getHeader(), this.getSigningInput());
        }
        catch (ActionRequiredForJWSCompletionException actionRequiredForJWSCompletionException) {
            throw new ActionRequiredForJWSCompletionException(actionRequiredForJWSCompletionException.getMessage(), actionRequiredForJWSCompletionException.getTriggeringOption(), new CompletableJWSObjectSigning(){

                @Override
                public Signature getInitializedSignature() {
                    return actionRequiredForJWSCompletionException.getCompletableJWSObjectSigning().getInitializedSignature();
                }

                @Override
                public Base64URL complete() throws JOSEException {
                    JWSObject.this.signature = actionRequiredForJWSCompletionException.getCompletableJWSObjectSigning().complete();
                    JWSObject.this.state.set(State.SIGNED);
                    return JWSObject.this.signature;
                }
            });
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
        this.state.set(State.SIGNED);
    }

    public synchronized boolean verify(JWSVerifier jWSVerifier) throws JOSEException {
        boolean bl2;
        this.ensureSignedOrVerifiedState();
        try {
            bl2 = jWSVerifier.verify(this.getHeader(), this.getSigningInput(), this.getSignature());
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
        if (bl2) {
            this.state.set(State.VERIFIED);
        }
        return bl2;
    }

    @Override
    public String serialize() {
        return this.serialize(false);
    }

    public String serialize(boolean bl2) {
        this.ensureSignedOrVerifiedState();
        if (bl2) {
            return this.header.toBase64URL().toString() + '.' + '.' + this.signature.toString();
        }
        return this.signingInputString + '.' + this.signature.toString();
    }

    public static JWSObject parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split(string);
        if (base64URLArray.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        return new JWSObject(base64URLArray[0], base64URLArray[1], base64URLArray[2]);
    }

    public static JWSObject parse(String string, Payload payload) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split(string);
        if (base64URLArray.length != 3) {
            throw new ParseException("Unexpected number of Base64URL parts, must be three", 0);
        }
        if (!base64URLArray[1].toString().isEmpty()) {
            throw new ParseException("The payload Base64URL part must be empty", 0);
        }
        return new JWSObject(base64URLArray[0], payload, base64URLArray[2]);
    }

    public static enum State {
        UNSIGNED,
        SIGNED,
        VERIFIED;

    }
}

