/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.HeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.IllegalHeaderException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectJSON;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.UnprotectedHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

@ThreadSafe
public class JWEObjectJSON
extends JOSEObjectJSON {
    private static final long serialVersionUID = 1L;
    private final JWEHeader header;
    private UnprotectedHeader unprotectedHeader;
    private final List<Recipient> recipients = new LinkedList<Recipient>();
    private Base64URL iv;
    private Base64URL cipherText;
    private Base64URL authTag;
    private final byte[] aad;
    private JWEObject.State state;

    public JWEObjectJSON(JWEObject jWEObject) {
        super(jWEObject.getPayload());
        this.header = jWEObject.getHeader();
        this.aad = null;
        this.iv = jWEObject.getIV();
        this.cipherText = jWEObject.getCipherText();
        this.authTag = jWEObject.getAuthTag();
        if (jWEObject.getState() == JWEObject.State.ENCRYPTED) {
            this.recipients.add(new Recipient(null, jWEObject.getEncryptedKey()));
            this.state = JWEObject.State.ENCRYPTED;
        } else if (jWEObject.getState() == JWEObject.State.DECRYPTED) {
            this.recipients.add(new Recipient(null, jWEObject.getEncryptedKey()));
            this.state = JWEObject.State.DECRYPTED;
        } else {
            this.state = JWEObject.State.UNENCRYPTED;
        }
    }

    public JWEObjectJSON(JWEHeader jWEHeader, Payload payload) {
        this(jWEHeader, payload, null, null);
    }

    public JWEObjectJSON(JWEHeader jWEHeader, Payload payload, UnprotectedHeader unprotectedHeader, byte[] byArray) {
        super(payload);
        this.header = Objects.requireNonNull(jWEHeader);
        this.setPayload(Objects.requireNonNull(payload));
        this.unprotectedHeader = unprotectedHeader;
        this.aad = byArray;
        this.cipherText = null;
        this.state = JWEObject.State.UNENCRYPTED;
    }

    public JWEObjectJSON(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, List<Recipient> list, UnprotectedHeader unprotectedHeader, byte[] byArray) {
        super(null);
        this.header = Objects.requireNonNull(jWEHeader);
        this.recipients.addAll(list);
        this.unprotectedHeader = unprotectedHeader;
        this.aad = byArray;
        this.iv = base64URL2;
        this.cipherText = Objects.requireNonNull(base64URL);
        this.authTag = base64URL3;
        this.state = JWEObject.State.ENCRYPTED;
    }

    public JWEHeader getHeader() {
        return this.header;
    }

    public UnprotectedHeader getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    public Base64URL getEncryptedKey() {
        if (this.recipients.isEmpty()) {
            return null;
        }
        if (this.recipients.size() == 1) {
            return this.recipients.get(0).getEncryptedKey();
        }
        List<Object> list = JSONArrayUtils.newJSONArray();
        for (Recipient recipient : this.recipients) {
            list.add(recipient.toJSONObject());
        }
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.put("recipients", list);
        return Base64URL.encode(JSONObjectUtils.toJSONString(map));
    }

    public Base64URL getIV() {
        return this.iv;
    }

    public Base64URL getCipherText() {
        return this.cipherText;
    }

    public Base64URL getAuthTag() {
        return this.authTag;
    }

    public byte[] getAAD() {
        StringBuilder stringBuilder = new StringBuilder(this.header.toBase64URL().toString());
        if (this.aad != null && this.aad.length > 0) {
            stringBuilder.append(".").append(new String(this.aad, StandardCharsets.US_ASCII));
        }
        return stringBuilder.toString().getBytes(StandardCharsets.US_ASCII);
    }

    public List<Recipient> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    public JWEObject.State getState() {
        return this.state;
    }

    private void ensureUnencryptedState() {
        if (this.state != JWEObject.State.UNENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an unencrypted state");
        }
    }

    private void ensureEncryptedState() {
        if (this.state != JWEObject.State.ENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted state");
        }
    }

    private void ensureEncryptedOrDecryptedState() {
        if (this.state != JWEObject.State.ENCRYPTED && this.state != JWEObject.State.DECRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted or decrypted state");
        }
    }

    private void ensureJWEEncrypterSupport(JWEEncrypter jWEEncrypter) throws JOSEException {
        if (!jWEEncrypter.supportedJWEAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The " + this.getHeader().getAlgorithm() + " algorithm is not supported by the JWE encrypter: Supported algorithms: " + jWEEncrypter.supportedJWEAlgorithms());
        }
        if (!jWEEncrypter.supportedEncryptionMethods().contains(this.getHeader().getEncryptionMethod())) {
            throw new JOSEException("The " + this.getHeader().getEncryptionMethod() + " encryption method or key size is not supported by the JWE encrypter: Supported methods: " + jWEEncrypter.supportedEncryptionMethods());
        }
    }

    public synchronized void encrypt(JWEEncrypter jWEEncrypter) throws JOSEException {
        JWECryptoParts jWECryptoParts;
        this.ensureUnencryptedState();
        this.ensureJWEEncrypterSupport(jWEEncrypter);
        JWEHeader jWEHeader = this.getHeader();
        try {
            jWEHeader = (JWEHeader)this.getHeader().join(this.unprotectedHeader);
            jWECryptoParts = jWEEncrypter.encrypt(jWEHeader, this.getPayload().toBytes(), this.getAAD());
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
        Base64URL base64URL = jWECryptoParts.getEncryptedKey();
        try {
            for (Map<String, Object> map : JSONObjectUtils.getJSONObjectArray(JSONObjectUtils.parse(base64URL.decodeToString()), "recipients")) {
                this.recipients.add(Recipient.parse(map));
            }
        }
        catch (Exception exception) {
            Map<String, Object> map = jWECryptoParts.getHeader().toJSONObject();
            for (String string : jWEHeader.getIncludedParams()) {
                if (!map.containsKey(string)) continue;
                map.remove(string);
            }
            try {
                this.recipients.add(new Recipient(UnprotectedHeader.parse(map), base64URL));
            }
            catch (Exception exception2) {
                throw new JOSEException(exception2.getMessage(), exception2);
            }
        }
        this.iv = jWECryptoParts.getInitializationVector();
        this.cipherText = jWECryptoParts.getCipherText();
        this.authTag = jWECryptoParts.getAuthenticationTag();
        this.state = JWEObject.State.ENCRYPTED;
    }

    public synchronized void decrypt(JWEDecrypter jWEDecrypter) throws JOSEException {
        this.ensureEncryptedState();
        try {
            this.setPayload(new Payload(jWEDecrypter.decrypt(this.getHeader(), this.getEncryptedKey(), this.getIV(), this.getCipherText(), this.getAuthTag(), this.getAAD())));
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
        this.state = JWEObject.State.DECRYPTED;
    }

    private Map<String, Object> toBaseJSONObject() {
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.put("protected", this.header.toBase64URL().toString());
        if (this.aad != null) {
            map.put("aad", new String(this.aad, StandardCharsets.US_ASCII));
        }
        map.put("ciphertext", this.cipherText.toString());
        map.put("iv", this.iv.toString());
        map.put("tag", this.authTag.toString());
        return map;
    }

    @Override
    public Map<String, Object> toGeneralJSONObject() {
        this.ensureEncryptedOrDecryptedState();
        if (this.recipients.isEmpty() || this.recipients.get(0).getUnprotectedHeader() == null && this.recipients.get(0).getEncryptedKey() == null) {
            throw new IllegalStateException("The general JWE JSON serialization requires at least one recipient");
        }
        Map<String, Object> map = this.toBaseJSONObject();
        if (this.unprotectedHeader != null) {
            map.put("unprotected", this.unprotectedHeader.toJSONObject());
        }
        List<Object> list = JSONArrayUtils.newJSONArray();
        for (Recipient recipient : this.recipients) {
            Map<String, Object> map2 = recipient.toJSONObject();
            list.add(map2);
        }
        map.put("recipients", list);
        return map;
    }

    @Override
    public Map<String, Object> toFlattenedJSONObject() {
        this.ensureEncryptedOrDecryptedState();
        if (this.recipients.size() != 1) {
            throw new IllegalStateException("The flattened JWE JSON serialization requires exactly one recipient");
        }
        Map<String, Object> map = this.toBaseJSONObject();
        Map<String, Object> map2 = JSONObjectUtils.newJSONObject();
        if (this.recipients.get(0).getUnprotectedHeader() != null) {
            map2.putAll(this.recipients.get(0).getUnprotectedHeader().toJSONObject());
        }
        if (this.unprotectedHeader != null) {
            map2.putAll(this.unprotectedHeader.toJSONObject());
        }
        if (map2.size() > 0) {
            map.put("unprotected", map2);
        }
        if (this.recipients.get(0).getEncryptedKey() != null) {
            map.put("encrypted_key", this.recipients.get(0).getEncryptedKey().toString());
        }
        return map;
    }

    @Override
    public String serializeGeneral() {
        return JSONObjectUtils.toJSONString(this.toGeneralJSONObject());
    }

    @Override
    public String serializeFlattened() {
        return JSONObjectUtils.toJSONString(this.toFlattenedJSONObject());
    }

    public static JWEObjectJSON parse(Map<String, Object> map) throws ParseException {
        if (!map.containsKey("protected")) {
            throw new ParseException("The JWE protected header mast be present", 0);
        }
        LinkedList<Recipient> linkedList = new LinkedList<Recipient>();
        JWEHeader jWEHeader = JWEHeader.parse(JSONObjectUtils.getBase64URL(map, "protected"));
        UnprotectedHeader unprotectedHeader = UnprotectedHeader.parse(JSONObjectUtils.getJSONObject(map, "unprotected"));
        Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "ciphertext");
        Base64URL base64URL2 = JSONObjectUtils.getBase64URL(map, "iv");
        Base64URL base64URL3 = JSONObjectUtils.getBase64URL(map, "tag");
        Base64URL base64URL4 = JSONObjectUtils.getBase64URL(map, "aad");
        JWEHeader jWEHeader2 = (JWEHeader)jWEHeader.join(unprotectedHeader);
        if (map.containsKey("recipients")) {
            Map<String, Object>[] mapArray = JSONObjectUtils.getJSONObjectArray(map, "recipients");
            if (mapArray == null || mapArray.length == 0) {
                throw new ParseException("The \"recipients\" member must be present in general JSON Serialization", 0);
            }
            for (Map<String, Object> map2 : mapArray) {
                Recipient recipient = Recipient.parse(map2);
                try {
                    HeaderValidation.ensureDisjoint(jWEHeader2, recipient.getUnprotectedHeader());
                }
                catch (IllegalHeaderException illegalHeaderException) {
                    throw new ParseException(illegalHeaderException.getMessage(), 0);
                }
                linkedList.add(recipient);
            }
        } else {
            Base64URL base64URL5 = JSONObjectUtils.getBase64URL(map, "encrypted_key");
            linkedList.add(new Recipient(null, base64URL5));
        }
        return new JWEObjectJSON(jWEHeader, base64URL, base64URL2, base64URL3, linkedList, unprotectedHeader, base64URL4 == null ? null : base64URL4.toString().getBytes(StandardCharsets.US_ASCII));
    }

    public static JWEObjectJSON parse(String string) throws ParseException {
        return JWEObjectJSON.parse(JSONObjectUtils.parse(Objects.requireNonNull(string)));
    }

    @Immutable
    public static final class Recipient {
        private final UnprotectedHeader unprotectedHeader;
        private final Base64URL encryptedKey;

        public Recipient(UnprotectedHeader unprotectedHeader, Base64URL base64URL) {
            this.unprotectedHeader = unprotectedHeader;
            this.encryptedKey = base64URL;
        }

        public UnprotectedHeader getUnprotectedHeader() {
            return this.unprotectedHeader;
        }

        public Base64URL getEncryptedKey() {
            return this.encryptedKey;
        }

        public Map<String, Object> toJSONObject() {
            Map<String, Object> map = JSONObjectUtils.newJSONObject();
            if (this.unprotectedHeader != null && !this.unprotectedHeader.getIncludedParams().isEmpty()) {
                map.put("header", this.unprotectedHeader.toJSONObject());
            }
            if (this.encryptedKey != null) {
                map.put("encrypted_key", this.encryptedKey.toString());
            }
            return map;
        }

        public static Recipient parse(Map<String, Object> map) throws ParseException {
            UnprotectedHeader unprotectedHeader = UnprotectedHeader.parse(JSONObjectUtils.getJSONObject(map, "header"));
            Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "encrypted_key");
            return new Recipient(unprotectedHeader, base64URL);
        }
    }
}

