/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CommonSEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CompressionAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertChainUtils;

@Immutable
public final class JWEHeader
extends CommonSEHeader {
    private static final long serialVersionUID = 1L;
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final EncryptionMethod enc;
    private final JWK epk;
    private final CompressionAlgorithm zip;
    private final Base64URL apu;
    private final Base64URL apv;
    private final Base64URL p2s;
    private final int p2c;
    private final Base64URL iv;
    private final Base64URL tag;
    private final String skid;

    public JWEHeader(EncryptionMethod encryptionMethod) {
        this(null, encryptionMethod, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, null, null, null, null, null);
    }

    public JWEHeader(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod) {
        this(jWEAlgorithm, encryptionMethod, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, null, null, null, null, null);
    }

    public JWEHeader(Algorithm algorithm, EncryptionMethod encryptionMethod, JOSEObjectType jOSEObjectType, String string, Set<String> set, URI uRI, JWK jWK, URI uRI2, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, String string2, JWK jWK2, CompressionAlgorithm compressionAlgorithm, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, int n2, Base64URL base64URL6, Base64URL base64URL7, String string3, Map<String, Object> map, Base64URL base64URL8) {
        super(algorithm, jOSEObjectType, string, set, uRI, jWK, uRI2, base64URL, base64URL2, list, string2, map, base64URL8);
        if (algorithm != null && algorithm.getName().equals(Algorithm.NONE.getName())) {
            throw new IllegalArgumentException("The JWE algorithm cannot be \"none\"");
        }
        if (jWK2 != null && jWK2.isPrivate()) {
            throw new IllegalArgumentException("Ephemeral public key should not be a private key");
        }
        this.enc = Objects.requireNonNull(encryptionMethod);
        this.epk = jWK2;
        this.zip = compressionAlgorithm;
        this.apu = base64URL3;
        this.apv = base64URL4;
        this.p2s = base64URL5;
        this.p2c = n2;
        this.iv = base64URL6;
        this.tag = base64URL7;
        this.skid = string3;
    }

    public JWEHeader(JWEHeader jWEHeader) {
        this(jWEHeader.getAlgorithm(), jWEHeader.getEncryptionMethod(), jWEHeader.getType(), jWEHeader.getContentType(), jWEHeader.getCriticalParams(), jWEHeader.getJWKURL(), jWEHeader.getJWK(), jWEHeader.getX509CertURL(), jWEHeader.getX509CertThumbprint(), jWEHeader.getX509CertSHA256Thumbprint(), jWEHeader.getX509CertChain(), jWEHeader.getKeyID(), jWEHeader.getEphemeralPublicKey(), jWEHeader.getCompressionAlgorithm(), jWEHeader.getAgreementPartyUInfo(), jWEHeader.getAgreementPartyVInfo(), jWEHeader.getPBES2Salt(), jWEHeader.getPBES2Count(), jWEHeader.getIV(), jWEHeader.getAuthTag(), jWEHeader.getSenderKeyID(), jWEHeader.getCustomParams(), jWEHeader.getParsedBase64URL());
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    @Override
    public JWEAlgorithm getAlgorithm() {
        return (JWEAlgorithm)super.getAlgorithm();
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.enc;
    }

    public JWK getEphemeralPublicKey() {
        return this.epk;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.zip;
    }

    public Base64URL getAgreementPartyUInfo() {
        return this.apu;
    }

    public Base64URL getAgreementPartyVInfo() {
        return this.apv;
    }

    public Base64URL getPBES2Salt() {
        return this.p2s;
    }

    public int getPBES2Count() {
        return this.p2c;
    }

    public Base64URL getIV() {
        return this.iv;
    }

    public Base64URL getAuthTag() {
        return this.tag;
    }

    public String getSenderKeyID() {
        return this.skid;
    }

    @Override
    public Set<String> getIncludedParams() {
        Set<String> set = super.getIncludedParams();
        if (this.enc != null) {
            set.add("enc");
        }
        if (this.epk != null) {
            set.add("epk");
        }
        if (this.zip != null) {
            set.add("zip");
        }
        if (this.apu != null) {
            set.add("apu");
        }
        if (this.apv != null) {
            set.add("apv");
        }
        if (this.p2s != null) {
            set.add("p2s");
        }
        if (this.p2c > 0) {
            set.add("p2c");
        }
        if (this.iv != null) {
            set.add("iv");
        }
        if (this.tag != null) {
            set.add("tag");
        }
        if (this.skid != null) {
            set.add("skid");
        }
        return set;
    }

    @Override
    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = super.toJSONObject();
        if (this.enc != null) {
            map.put("enc", this.enc.toString());
        }
        if (this.epk != null) {
            map.put("epk", this.epk.toJSONObject());
        }
        if (this.zip != null) {
            map.put("zip", this.zip.toString());
        }
        if (this.apu != null) {
            map.put("apu", this.apu.toString());
        }
        if (this.apv != null) {
            map.put("apv", this.apv.toString());
        }
        if (this.p2s != null) {
            map.put("p2s", this.p2s.toString());
        }
        if (this.p2c > 0) {
            map.put("p2c", this.p2c);
        }
        if (this.iv != null) {
            map.put("iv", this.iv.toString());
        }
        if (this.tag != null) {
            map.put("tag", this.tag.toString());
        }
        if (this.skid != null) {
            map.put("skid", this.skid);
        }
        return map;
    }

    private static EncryptionMethod parseEncryptionMethod(Map<String, Object> map) throws ParseException {
        return EncryptionMethod.parse(JSONObjectUtils.getString(map, "enc"));
    }

    public static JWEHeader parse(Map<String, Object> map) throws ParseException {
        return JWEHeader.parse(map, null);
    }

    public static JWEHeader parse(Map<String, Object> map, Base64URL base64URL) throws ParseException {
        EncryptionMethod encryptionMethod = JWEHeader.parseEncryptionMethod(map);
        Builder builder = new Builder(encryptionMethod).parsedBase64URL(base64URL);
        for (String string : map.keySet()) {
            Object object;
            if ("alg".equals(string)) {
                builder = builder.alg(JWEAlgorithm.parse(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("enc".equals(string)) continue;
            if ("typ".equals(string)) {
                object = JSONObjectUtils.getString(map, string);
                if (object == null) continue;
                builder = builder.type(new JOSEObjectType((String)object));
                continue;
            }
            if ("cty".equals(string)) {
                builder = builder.contentType(JSONObjectUtils.getString(map, string));
                continue;
            }
            if ("crit".equals(string)) {
                object = JSONObjectUtils.getStringList(map, string);
                if (object == null) continue;
                builder = builder.criticalParams(new HashSet<String>((Collection<String>)object));
                continue;
            }
            if ("jku".equals(string)) {
                builder = builder.jwkURL(JSONObjectUtils.getURI(map, string));
                continue;
            }
            if ("jwk".equals(string)) {
                builder = builder.jwk(CommonSEHeader.parsePublicJWK(JSONObjectUtils.getJSONObject(map, string)));
                continue;
            }
            if ("x5u".equals(string)) {
                builder = builder.x509CertURL(JSONObjectUtils.getURI(map, string));
                continue;
            }
            if ("x5t".equals(string)) {
                builder = builder.x509CertThumbprint(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("x5t#S256".equals(string)) {
                builder = builder.x509CertSHA256Thumbprint(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("x5c".equals(string)) {
                builder = builder.x509CertChain(X509CertChainUtils.toBase64List(JSONObjectUtils.getJSONArray(map, string)));
                continue;
            }
            if ("kid".equals(string)) {
                builder = builder.keyID(JSONObjectUtils.getString(map, string));
                continue;
            }
            if ("epk".equals(string)) {
                builder = builder.ephemeralPublicKey(JWK.parse(JSONObjectUtils.getJSONObject(map, string)));
                continue;
            }
            if ("zip".equals(string)) {
                object = JSONObjectUtils.getString(map, string);
                if (object == null) continue;
                builder = builder.compressionAlgorithm(new CompressionAlgorithm((String)object));
                continue;
            }
            if ("apu".equals(string)) {
                builder = builder.agreementPartyUInfo(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("apv".equals(string)) {
                builder = builder.agreementPartyVInfo(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("p2s".equals(string)) {
                builder = builder.pbes2Salt(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("p2c".equals(string)) {
                builder = builder.pbes2Count(JSONObjectUtils.getInt(map, string));
                continue;
            }
            if ("iv".equals(string)) {
                builder = builder.iv(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("tag".equals(string)) {
                builder = builder.authTag(Base64URL.from(JSONObjectUtils.getString(map, string)));
                continue;
            }
            if ("skid".equals(string)) {
                builder = builder.senderKeyID(JSONObjectUtils.getString(map, string));
                continue;
            }
            builder = builder.customParam(string, map.get(string));
        }
        return builder.build();
    }

    public static JWEHeader parse(String string) throws ParseException {
        return JWEHeader.parse(JSONObjectUtils.parse(string), null);
    }

    public static JWEHeader parse(String string, Base64URL base64URL) throws ParseException {
        return JWEHeader.parse(JSONObjectUtils.parse(string, 20000), base64URL);
    }

    public static JWEHeader parse(Base64URL base64URL) throws ParseException {
        return JWEHeader.parse(base64URL.decodeToString(), base64URL);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("alg");
        hashSet.add("enc");
        hashSet.add("epk");
        hashSet.add("zip");
        hashSet.add("jku");
        hashSet.add("jwk");
        hashSet.add("x5u");
        hashSet.add("x5t");
        hashSet.add("x5t#S256");
        hashSet.add("x5c");
        hashSet.add("kid");
        hashSet.add("typ");
        hashSet.add("cty");
        hashSet.add("crit");
        hashSet.add("apu");
        hashSet.add("apv");
        hashSet.add("p2s");
        hashSet.add("p2c");
        hashSet.add("iv");
        hashSet.add("tag");
        hashSet.add("skid");
        hashSet.add("authTag");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private final EncryptionMethod enc;
        private JWEAlgorithm alg;
        private JOSEObjectType typ;
        private String cty;
        private Set<String> crit;
        private URI jku;
        private JWK jwk;
        private URI x5u;
        @Deprecated
        private Base64URL x5t;
        private Base64URL x5t256;
        private List<Base64> x5c;
        private String kid;
        private JWK epk;
        private CompressionAlgorithm zip;
        private Base64URL apu;
        private Base64URL apv;
        private Base64URL p2s;
        private int p2c;
        private Base64URL iv;
        private Base64URL tag;
        private String skid;
        private Map<String, Object> customParams;
        private Base64URL parsedBase64URL;

        public Builder(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod) {
            if (jWEAlgorithm.getName().equals(Algorithm.NONE.getName())) {
                throw new IllegalArgumentException("The JWE algorithm \"alg\" cannot be \"none\"");
            }
            this.alg = jWEAlgorithm;
            this.enc = Objects.requireNonNull(encryptionMethod);
        }

        public Builder(EncryptionMethod encryptionMethod) {
            this.enc = Objects.requireNonNull(encryptionMethod);
        }

        public Builder(JWEHeader jWEHeader) {
            this(jWEHeader.getEncryptionMethod());
            this.alg = jWEHeader.getAlgorithm();
            this.typ = jWEHeader.getType();
            this.cty = jWEHeader.getContentType();
            this.crit = jWEHeader.getCriticalParams();
            this.customParams = jWEHeader.getCustomParams();
            this.jku = jWEHeader.getJWKURL();
            this.jwk = jWEHeader.getJWK();
            this.x5u = jWEHeader.getX509CertURL();
            this.x5t = jWEHeader.getX509CertThumbprint();
            this.x5t256 = jWEHeader.getX509CertSHA256Thumbprint();
            this.x5c = jWEHeader.getX509CertChain();
            this.kid = jWEHeader.getKeyID();
            this.epk = jWEHeader.getEphemeralPublicKey();
            this.zip = jWEHeader.getCompressionAlgorithm();
            this.apu = jWEHeader.getAgreementPartyUInfo();
            this.apv = jWEHeader.getAgreementPartyVInfo();
            this.p2s = jWEHeader.getPBES2Salt();
            this.p2c = jWEHeader.getPBES2Count();
            this.iv = jWEHeader.getIV();
            this.tag = jWEHeader.getAuthTag();
            this.skid = jWEHeader.getSenderKeyID();
            this.customParams = jWEHeader.getCustomParams();
        }

        public Builder alg(JWEAlgorithm jWEAlgorithm) {
            this.alg = jWEAlgorithm;
            return this;
        }

        public Builder type(JOSEObjectType jOSEObjectType) {
            this.typ = jOSEObjectType;
            return this;
        }

        public Builder contentType(String string) {
            this.cty = string;
            return this;
        }

        public Builder criticalParams(Set<String> set) {
            this.crit = set;
            return this;
        }

        public Builder jwkURL(URI uRI) {
            this.jku = uRI;
            return this;
        }

        public Builder jwk(JWK jWK) {
            if (jWK != null && jWK.isPrivate()) {
                throw new IllegalArgumentException("The JWK must be public");
            }
            this.jwk = jWK;
            return this;
        }

        public Builder x509CertURL(URI uRI) {
            this.x5u = uRI;
            return this;
        }

        @Deprecated
        public Builder x509CertThumbprint(Base64URL base64URL) {
            this.x5t = base64URL;
            return this;
        }

        public Builder x509CertSHA256Thumbprint(Base64URL base64URL) {
            this.x5t256 = base64URL;
            return this;
        }

        public Builder x509CertChain(List<Base64> list) {
            this.x5c = list;
            return this;
        }

        public Builder keyID(String string) {
            this.kid = string;
            return this;
        }

        public Builder ephemeralPublicKey(JWK jWK) {
            this.epk = jWK;
            return this;
        }

        public Builder compressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.zip = compressionAlgorithm;
            return this;
        }

        public Builder agreementPartyUInfo(Base64URL base64URL) {
            this.apu = base64URL;
            return this;
        }

        public Builder agreementPartyVInfo(Base64URL base64URL) {
            this.apv = base64URL;
            return this;
        }

        public Builder pbes2Salt(Base64URL base64URL) {
            this.p2s = base64URL;
            return this;
        }

        public Builder pbes2Count(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("The PBES2 count parameter must not be negative");
            }
            this.p2c = n2;
            return this;
        }

        public Builder iv(Base64URL base64URL) {
            this.iv = base64URL;
            return this;
        }

        public Builder authTag(Base64URL base64URL) {
            this.tag = base64URL;
            return this;
        }

        public Builder senderKeyID(String string) {
            this.skid = string;
            return this;
        }

        public Builder customParam(String string, Object object) {
            if (JWEHeader.getRegisteredParameterNames().contains(string)) {
                throw new IllegalArgumentException("The parameter name \"" + string + "\" matches a registered name");
            }
            if (this.customParams == null) {
                this.customParams = new HashMap<String, Object>();
            }
            this.customParams.put(string, object);
            return this;
        }

        public Builder customParams(Map<String, Object> map) {
            this.customParams = map;
            return this;
        }

        public Builder parsedBase64URL(Base64URL base64URL) {
            this.parsedBase64URL = base64URL;
            return this;
        }

        public JWEHeader build() {
            return new JWEHeader(this.alg, this.enc, this.typ, this.cty, this.crit, this.jku, this.jwk, this.x5u, this.x5t, this.x5t256, this.x5c, this.kid, this.epk, this.zip, this.apu, this.apv, this.p2s, this.p2c, this.iv, this.tag, this.skid, this.customParams, this.parsedBase64URL);
        }
    }
}

