/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObjectJSON;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

public abstract class JOSEObjectJSON
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE_JOSE_JSON = "application/jose+json; charset=UTF-8";
    private Payload payload;

    protected JOSEObjectJSON(Payload payload) {
        this.payload = payload;
    }

    protected void setPayload(Payload payload) {
        this.payload = payload;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public abstract Map<String, Object> toGeneralJSONObject();

    public abstract Map<String, Object> toFlattenedJSONObject();

    public abstract String serializeGeneral();

    public abstract String serializeFlattened();

    public static JOSEObjectJSON parse(Map<String, Object> map) throws ParseException {
        if (map.containsKey("signature") || map.containsKey("signatures")) {
            return JWSObjectJSON.parse(map);
        }
        if (map.containsKey("ciphertext")) {
            throw new ParseException("JWE JSON not supported", 0);
        }
        throw new ParseException("Invalid JOSE object", 0);
    }

    public static JOSEObjectJSON parse(String string) throws ParseException {
        Objects.requireNonNull(string);
        return JOSEObjectJSON.parse(JSONObjectUtils.parse(string));
    }
}

