/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PopParameters;

public class UserNamePasswordParameters
implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private String username;
    @NonNull
    private char[] password;
    private ClaimsRequest claims;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;
    private PopParameters proofOfPossession;

    public char[] password() {
        return (char[])this.password.clone();
    }

    private static UserNamePasswordParametersBuilder builder() {
        return new UserNamePasswordParametersBuilder();
    }

    public static UserNamePasswordParametersBuilder builder(Set<String> set, String string, char[] cArray) {
        ParameterValidationUtils.validateNotNull("scopes", set);
        ParameterValidationUtils.validateNotBlank("username", string);
        ParameterValidationUtils.validateNotEmpty("password", cArray);
        return UserNamePasswordParameters.builder().scopes(set).username(string).password(cArray);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public String username() {
        return this.username;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    public PopParameters proofOfPossession() {
        return this.proofOfPossession;
    }

    private UserNamePasswordParameters(@NonNull Set<String> set, @NonNull String string, @NonNull char[] cArray, ClaimsRequest claimsRequest, Map<String, String> map, Map<String, String> map2, String string2, PopParameters popParameters) {
        if (set == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (string == null) {
            throw new NullPointerException("username is marked @NonNull but is null");
        }
        if (cArray == null) {
            throw new NullPointerException("password is marked @NonNull but is null");
        }
        this.scopes = set;
        this.username = string;
        this.password = cArray;
        this.claims = claimsRequest;
        this.extraHttpHeaders = map;
        this.extraQueryParameters = map2;
        this.tenant = string2;
        this.proofOfPossession = popParameters;
    }

    public static class UserNamePasswordParametersBuilder {
        private Set<String> scopes;
        private String username;
        private char[] password;
        private ClaimsRequest claims;
        private Map<String, String> extraHttpHeaders;
        private Map<String, String> extraQueryParameters;
        private String tenant;
        private PopParameters proofOfPossession;

        public UserNamePasswordParametersBuilder password(char[] cArray) {
            this.password = (char[])cArray.clone();
            return this;
        }

        public UserNamePasswordParametersBuilder proofOfPossession(HttpMethod httpMethod, URI uRI, String string) {
            this.proofOfPossession = new PopParameters(httpMethod, uRI, string);
            return this;
        }

        UserNamePasswordParametersBuilder() {
        }

        public UserNamePasswordParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public UserNamePasswordParametersBuilder username(String string) {
            this.username = string;
            return this;
        }

        public UserNamePasswordParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public UserNamePasswordParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public UserNamePasswordParametersBuilder extraQueryParameters(Map<String, String> map) {
            this.extraQueryParameters = map;
            return this;
        }

        public UserNamePasswordParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public UserNamePasswordParameters build() {
            return new UserNamePasswordParameters(this.scopes, this.username, this.password, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant, this.proofOfPossession);
        }

        public String toString() {
            return "UserNamePasswordParameters.UserNamePasswordParametersBuilder(scopes=" + this.scopes + ", username=" + this.username + ", password=" + Arrays.toString(this.password) + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", proofOfPossession=" + this.proofOfPossession + ")";
        }
    }
}

