/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AccountCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultMetadata;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.B2CAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientAssertion;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HTTPContentType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IdToken;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceExceptionFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OAuthHttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class TokenRequestExecutor {
    Logger log = LoggerFactory.getLogger(TokenRequestExecutor.class);
    final Authority requestAuthority;
    final String tenant;
    private final MsalRequest msalRequest;
    private final ServiceBundle serviceBundle;

    TokenRequestExecutor(Authority authority, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        this.requestAuthority = authority;
        this.serviceBundle = serviceBundle;
        this.msalRequest = msalRequest;
        this.tenant = msalRequest.requestContext().apiParameters().tenant() == null ? msalRequest.application().tenant() : msalRequest.requestContext().apiParameters().tenant();
    }

    AuthenticationResult executeTokenRequest() throws ParseException, IOException {
        this.log.debug("Sending token request to: {}", (Object)this.requestAuthority.canonicalAuthorityUrl());
        OAuthHttpRequest oAuthHttpRequest = this.createOauthHttpRequest();
        HTTPResponse hTTPResponse = oAuthHttpRequest.send();
        return this.createAuthenticationResultFromOauthHttpResponse(hTTPResponse);
    }

    OAuthHttpRequest createOauthHttpRequest() throws SerializeException, MalformedURLException, ParseException {
        Map<String, List<String>> map;
        if (this.requestAuthority.tokenEndpointUrl() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        OAuthHttpRequest oAuthHttpRequest = new OAuthHttpRequest(HTTPRequest.Method.POST, this.requestAuthority.tokenEndpointUrl(), this.msalRequest.headers().getReadonlyHeaderMap(), this.msalRequest.requestContext(), this.serviceBundle);
        oAuthHttpRequest.setContentType(HTTPContentType.ApplicationURLEncoded.contentType);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(this.msalRequest.msalAuthorizationGrant().toParameters());
        if (this.msalRequest.application() instanceof AbstractClientApplicationBase && ((AbstractClientApplicationBase)this.msalRequest.application()).clientCapabilities() != null) {
            hashMap.put("claims", Collections.singletonList(((AbstractClientApplicationBase)this.msalRequest.application()).clientCapabilities()));
        }
        if (this.msalRequest.msalAuthorizationGrant.getClaims() != null) {
            map = this.msalRequest.msalAuthorizationGrant.getClaims().formatAsJSONString();
            if (hashMap.get("claims") != null) {
                map = JsonHelper.mergeJSONString((String)((List)hashMap.get("claims")).get(0), (String)((Object)map));
            }
            hashMap.put("claims", Collections.singletonList(map));
        }
        if (this.msalRequest.requestContext().apiParameters().extraQueryParameters() != null) {
            for (String string : this.msalRequest.requestContext().apiParameters().extraQueryParameters().keySet()) {
                if (hashMap.containsKey(string)) {
                    this.log.warn("A query parameter {} has been provided with values multiple times.", (Object)string);
                }
                hashMap.put(string, Collections.singletonList(this.msalRequest.requestContext().apiParameters().extraQueryParameters().get(string)));
            }
        }
        oAuthHttpRequest.setQuery(URLUtils.serializeParameters(hashMap));
        if (this.msalRequest.application() instanceof AbstractClientApplicationBase && ((AbstractClientApplicationBase)this.msalRequest.application()).clientAuthentication() != null) {
            String string;
            map = oAuthHttpRequest.getQueryParameters();
            string = this.msalRequest.application().clientId();
            map.put("client_id", Arrays.asList(string));
            oAuthHttpRequest.setQuery(URLUtils.serializeParameters(map));
            if (this.msalRequest instanceof ClientCredentialRequest && ((ClientCredentialRequest)this.msalRequest).parameters.clientCredential() != null) {
                ((ConfidentialClientApplication)this.msalRequest.application()).createClientAuthFromClientAssertion((ClientAssertion)((ClientCredentialRequest)this.msalRequest).parameters.clientCredential()).applyTo(oAuthHttpRequest);
            } else {
                ((AbstractClientApplicationBase)this.msalRequest.application()).clientAuthentication().applyTo(oAuthHttpRequest);
            }
        }
        return oAuthHttpRequest;
    }

    private AuthenticationResult createAuthenticationResultFromOauthHttpResponse(HTTPResponse hTTPResponse) throws ParseException {
        AccountCacheEntity accountCacheEntity;
        String string;
        OIDCTokens oIDCTokens;
        TokenResponse tokenResponse;
        if (hTTPResponse.getStatusCode() == 200) {
            tokenResponse = TokenResponse.parseHttpResponse(hTTPResponse);
            oIDCTokens = tokenResponse.getOIDCTokens();
            string = null;
            if (oIDCTokens.getRefreshToken() != null) {
                string = oIDCTokens.getRefreshToken().getValue();
            }
            accountCacheEntity = null;
            if (oIDCTokens.getIDToken() != null) {
                String string2 = oIDCTokens.getIDToken().getParsedParts()[1].decodeToString();
                IdToken idToken = JsonHelper.convertJsonToObject(string2, IdToken.class);
                AuthorityType authorityType = this.msalRequest.application().authenticationAuthority.authorityType;
                if (!StringHelper.isBlank(tokenResponse.getClientInfo())) {
                    if (authorityType == AuthorityType.B2C) {
                        B2CAuthority b2CAuthority = (B2CAuthority)this.msalRequest.application().authenticationAuthority;
                        accountCacheEntity = AccountCacheEntity.create(tokenResponse.getClientInfo(), this.requestAuthority, idToken, b2CAuthority.policy());
                    } else {
                        accountCacheEntity = AccountCacheEntity.create(tokenResponse.getClientInfo(), this.requestAuthority, idToken);
                    }
                } else if (authorityType == AuthorityType.ADFS) {
                    accountCacheEntity = AccountCacheEntity.createADFSAccount(this.requestAuthority, idToken);
                }
            }
        } else {
            if (hTTPResponse.getStatusCode() == 429 || hTTPResponse.getStatusCode() >= 500) {
                this.serviceBundle.getServerSideTelemetry().previousRequests.putAll(this.serviceBundle.getServerSideTelemetry().previousRequestInProgress);
            }
            throw MsalServiceExceptionFactory.fromHttpResponse(hTTPResponse);
        }
        long l2 = new Date().getTime() / 1000L;
        AuthenticationResult authenticationResult = AuthenticationResult.builder().accessToken(oIDCTokens.getAccessToken().getValue()).refreshToken(string).familyId(tokenResponse.getFoci()).idToken(oIDCTokens.getIDTokenString()).environment(this.requestAuthority.host()).expiresOn(l2 + tokenResponse.getExpiresIn()).extExpiresOn(tokenResponse.getExtExpiresIn() > 0L ? l2 + tokenResponse.getExtExpiresIn() : 0L).refreshOn(tokenResponse.getRefreshIn() > 0L ? l2 + tokenResponse.getRefreshIn() : 0L).accountCacheEntity(accountCacheEntity).scopes(tokenResponse.getScope()).metadata(new AuthenticationResultMetadata(TokenSource.IDENTITY_PROVIDER)).build();
        return authenticationResult;
    }

    Logger getLog() {
        return this.log;
    }

    Authority getRequestAuthority() {
        return this.requestAuthority;
    }

    String getTenant() {
        return this.tenant;
    }

    MsalRequest getMsalRequest() {
        return this.msalRequest;
    }

    ServiceBundle getServiceBundle() {
        return this.serviceBundle;
    }
}

