/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.UUID;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserIdentifier;

class RequestContext {
    private String telemetryRequestId;
    private String clientId;
    private String correlationId;
    private PublicApi publicApi;
    private String applicationName;
    private String applicationVersion;
    private String authority;
    private IAcquireTokenParameters apiParameters;
    private IApplicationBase clientApplication;
    private UserIdentifier userIdentifier;

    public RequestContext(AbstractApplicationBase abstractApplicationBase, PublicApi publicApi, IAcquireTokenParameters iAcquireTokenParameters) {
        this.clientApplication = abstractApplicationBase;
        this.clientId = StringHelper.isBlank(abstractApplicationBase.clientId()) ? "unset_client_id" : abstractApplicationBase.clientId();
        String string = this.correlationId = StringHelper.isBlank(abstractApplicationBase.correlationId()) ? RequestContext.generateNewCorrelationId() : abstractApplicationBase.correlationId();
        if (abstractApplicationBase instanceof AbstractClientApplicationBase) {
            this.applicationVersion = ((AbstractClientApplicationBase)abstractApplicationBase).applicationVersion();
            this.applicationName = ((AbstractClientApplicationBase)abstractApplicationBase).applicationName();
        }
        this.publicApi = publicApi;
        this.authority = abstractApplicationBase.authority();
        this.apiParameters = iAcquireTokenParameters;
    }

    public RequestContext(AbstractApplicationBase abstractApplicationBase, PublicApi publicApi, IAcquireTokenParameters iAcquireTokenParameters, UserIdentifier userIdentifier) {
        this(abstractApplicationBase, publicApi, iAcquireTokenParameters);
        this.userIdentifier = userIdentifier;
    }

    private static String generateNewCorrelationId() {
        return UUID.randomUUID().toString();
    }

    String telemetryRequestId() {
        return this.telemetryRequestId;
    }

    String clientId() {
        return this.clientId;
    }

    String correlationId() {
        return this.correlationId;
    }

    PublicApi publicApi() {
        return this.publicApi;
    }

    String applicationName() {
        return this.applicationName;
    }

    String applicationVersion() {
        return this.applicationVersion;
    }

    String authority() {
        return this.authority;
    }

    IAcquireTokenParameters apiParameters() {
        return this.apiParameters;
    }

    IApplicationBase clientApplication() {
        return this.clientApplication;
    }

    UserIdentifier userIdentifier() {
        return this.userIdentifier;
    }

    RequestContext telemetryRequestId(String string) {
        this.telemetryRequestId = string;
        return this;
    }
}

