/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;

public class RefreshTokenParameters
implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private String refreshToken;
    private ClaimsRequest claims;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;

    private static RefreshTokenParametersBuilder builder() {
        return new RefreshTokenParametersBuilder();
    }

    public static RefreshTokenParametersBuilder builder(Set<String> set, String string) {
        ParameterValidationUtils.validateNotBlank("refreshToken", string);
        return RefreshTokenParameters.builder().scopes(set).refreshToken(string);
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public String refreshToken() {
        return this.refreshToken;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    private RefreshTokenParameters(@NonNull Set<String> set, @NonNull String string, ClaimsRequest claimsRequest, Map<String, String> map, Map<String, String> map2, String string2) {
        if (set == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (string == null) {
            throw new NullPointerException("refreshToken is marked @NonNull but is null");
        }
        this.scopes = set;
        this.refreshToken = string;
        this.claims = claimsRequest;
        this.extraHttpHeaders = map;
        this.extraQueryParameters = map2;
        this.tenant = string2;
    }

    public static class RefreshTokenParametersBuilder {
        private Set<String> scopes;
        private String refreshToken;
        private ClaimsRequest claims;
        private Map<String, String> extraHttpHeaders;
        private Map<String, String> extraQueryParameters;
        private String tenant;

        RefreshTokenParametersBuilder() {
        }

        public RefreshTokenParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public RefreshTokenParametersBuilder refreshToken(String string) {
            this.refreshToken = string;
            return this;
        }

        public RefreshTokenParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public RefreshTokenParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public RefreshTokenParametersBuilder extraQueryParameters(Map<String, String> map) {
            this.extraQueryParameters = map;
            return this;
        }

        public RefreshTokenParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public RefreshTokenParameters build() {
            return new RefreshTokenParameters(this.scopes, this.refreshToken, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        public String toString() {
            return "RefreshTokenParameters.RefreshTokenParametersBuilder(scopes=" + this.scopes + ", refreshToken=" + this.refreshToken + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }
}

