/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientAuthenticationPost;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IBroker;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IPublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserIdentifier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

public class PublicClientApplication
extends AbstractClientApplicationBase
implements IPublicClientApplication {
    private final ClientAuthenticationPost clientAuthentication;
    private IBroker broker;
    private boolean brokerEnabled;

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(UserNamePasswordParameters userNamePasswordParameters) {
        CompletableFuture<IAuthenticationResult> completableFuture;
        ParameterValidationUtils.validateNotNull("parameters", userNamePasswordParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_USERNAME_PASSWORD, userNamePasswordParameters, UserIdentifier.fromUpn(userNamePasswordParameters.username()));
        if (this.validateBrokerUsage(userNamePasswordParameters)) {
            completableFuture = this.broker.acquireToken(this, userNamePasswordParameters);
        } else {
            UserNamePasswordRequest userNamePasswordRequest = new UserNamePasswordRequest(userNamePasswordParameters, this, requestContext);
            completableFuture = this.executeRequest(userNamePasswordRequest);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(IntegratedWindowsAuthenticationParameters integratedWindowsAuthenticationParameters) {
        ParameterValidationUtils.validateNotNull("parameters", integratedWindowsAuthenticationParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_INTEGRATED_WINDOWS_AUTH, integratedWindowsAuthenticationParameters, UserIdentifier.fromUpn(integratedWindowsAuthenticationParameters.username()));
        IntegratedWindowsAuthenticationRequest integratedWindowsAuthenticationRequest = new IntegratedWindowsAuthenticationRequest(integratedWindowsAuthenticationParameters, this, requestContext);
        return this.executeRequest(integratedWindowsAuthenticationRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(DeviceCodeFlowParameters deviceCodeFlowParameters) {
        if (AuthorityType.B2C.equals((Object)this.authenticationAuthority.authorityType())) {
            throw new IllegalArgumentException("Invalid authority type. Device Flow is not supported by B2C authority.");
        }
        ParameterValidationUtils.validateNotNull("parameters", deviceCodeFlowParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_DEVICE_CODE_FLOW, deviceCodeFlowParameters);
        AtomicReference<CompletableFuture<IAuthenticationResult>> atomicReference = new AtomicReference<CompletableFuture<IAuthenticationResult>>();
        DeviceCodeFlowRequest deviceCodeFlowRequest = new DeviceCodeFlowRequest(deviceCodeFlowParameters, atomicReference, this, requestContext);
        CompletableFuture<IAuthenticationResult> completableFuture = this.executeRequest(deviceCodeFlowRequest);
        atomicReference.set(completableFuture);
        return completableFuture;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(InteractiveRequestParameters interactiveRequestParameters) {
        ParameterValidationUtils.validateNotNull("parameters", interactiveRequestParameters);
        AtomicReference<CompletableFuture<IAuthenticationResult>> atomicReference = new AtomicReference<CompletableFuture<IAuthenticationResult>>();
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_INTERACTIVE, interactiveRequestParameters, UserIdentifier.fromUpn(interactiveRequestParameters.loginHint()));
        InteractiveRequest interactiveRequest = new InteractiveRequest(interactiveRequestParameters, atomicReference, this, requestContext);
        CompletableFuture<IAuthenticationResult> completableFuture = this.validateBrokerUsage(interactiveRequestParameters) ? this.broker.acquireToken(this, interactiveRequestParameters) : this.executeRequest(interactiveRequest);
        atomicReference.set(completableFuture);
        return completableFuture;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireTokenSilently(SilentParameters silentParameters) throws MalformedURLException {
        CompletableFuture<IAuthenticationResult> completableFuture = this.validateBrokerUsage(silentParameters) ? this.broker.acquireToken(this, silentParameters) : super.acquireTokenSilently(silentParameters);
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> removeAccount(IAccount iAccount) {
        if (this.brokerEnabled) {
            this.broker.removeAccount(this, iAccount);
        }
        return super.removeAccount(iAccount);
    }

    private PublicClientApplication(Builder builder) {
        super(builder);
        ParameterValidationUtils.validateNotBlank("clientId", this.clientId());
        this.log = LoggerFactory.getLogger(PublicClientApplication.class);
        this.clientAuthentication = new ClientAuthenticationPost(ClientAuthenticationMethod.NONE, new ClientID(this.clientId()));
        this.broker = builder.broker;
        this.brokerEnabled = builder.brokerEnabled;
        this.tenant = this.authenticationAuthority.tenant;
    }

    @Override
    protected ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public static Builder builder(String string) {
        return new Builder(string);
    }

    private boolean validateBrokerUsage(InteractiveRequestParameters interactiveRequestParameters) {
        if (!this.brokerEnabled && interactiveRequestParameters.proofOfPossession() != null) {
            throw new MsalClientException("InteractiveRequestParameters.proofOfPossession should not be used when broker is not available, see https://aka.ms/msal4j-pop for more information", "brokers_package_error");
        }
        return this.brokerEnabled;
    }

    private boolean validateBrokerUsage(UserNamePasswordParameters userNamePasswordParameters) {
        if (!this.brokerEnabled && userNamePasswordParameters.proofOfPossession() != null) {
            throw new MsalClientException("UserNamePasswordParameters.proofOfPossession should not be used when broker is not available, see https://aka.ms/msal4j-pop for more information", "brokers_package_error");
        }
        return this.brokerEnabled;
    }

    private boolean validateBrokerUsage(SilentParameters silentParameters) {
        if (!this.brokerEnabled && silentParameters.proofOfPossession() != null) {
            throw new MsalClientException("UserNamePasswordParameters.proofOfPossession should not be used when broker is not available, see https://aka.ms/msal4j-pop for more information", "brokers_package_error");
        }
        return this.brokerEnabled;
    }

    public static class Builder
    extends AbstractClientApplicationBase.Builder<Builder> {
        private IBroker broker = null;
        private boolean brokerEnabled = false;

        private Builder(String string) {
            super(string);
        }

        public Builder broker(IBroker iBroker) {
            this.broker = iBroker;
            this.brokerEnabled = this.broker.isBrokerAvailable();
            return this.self();
        }

        @Override
        public PublicClientApplication build() {
            return new PublicClientApplication(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

