/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonInclude;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestedClaimAdditionalInfo;

class JsonHelper {
    static ObjectMapper mapper = new ObjectMapper();

    private JsonHelper() {
    }

    static <T> T convertJsonToObject(String string, Class<T> clazz) {
        try {
            return mapper.readValue(string, clazz);
        }
        catch (IOException iOException) {
            throw new MsalClientException(iOException);
        }
    }

    static void validateJsonFormat(String string) {
        try {
            mapper.readTree(string);
        }
        catch (IOException iOException) {
            throw new MsalClientException(iOException.getMessage(), "invalid_json");
        }
    }

    public static String formCapabilitiesJson(Set<String> set) {
        if (set != null && !set.isEmpty()) {
            ClaimsRequest claimsRequest = new ClaimsRequest();
            RequestedClaimAdditionalInfo requestedClaimAdditionalInfo = new RequestedClaimAdditionalInfo(false, null, new ArrayList<String>(set));
            claimsRequest.requestClaimInAccessToken("xms_cc", requestedClaimAdditionalInfo);
            return claimsRequest.formatAsJSONString();
        }
        return null;
    }

    static String mergeJSONString(String string, String string2) {
        JsonNode jsonNode;
        JsonNode jsonNode2;
        try {
            jsonNode2 = mapper.readTree(string);
            jsonNode = mapper.readTree(string2);
        }
        catch (IOException iOException) {
            throw new MsalClientException(iOException.getMessage(), "invalid_json");
        }
        JsonHelper.mergeJSONNode(jsonNode2, jsonNode);
        return jsonNode2.toString();
    }

    static void mergeJSONNode(JsonNode jsonNode, JsonNode jsonNode2) {
        if (jsonNode2 == null) {
            return;
        }
        Iterator<String> iterator = jsonNode2.fieldNames();
        while (iterator.hasNext()) {
            String string = iterator.next();
            JsonNode jsonNode3 = jsonNode.get(string);
            if (jsonNode3 != null && jsonNode3.isObject()) {
                JsonHelper.mergeJSONNode(jsonNode3, jsonNode2.get(string));
                continue;
            }
            if (!(jsonNode instanceof ObjectNode)) continue;
            JsonNode jsonNode4 = jsonNode2.get(string);
            ((ObjectNode)jsonNode).put(string, jsonNode4);
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

