/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationRequestUrlParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

class InteractiveRequest
extends MsalRequest {
    private AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference;
    private InteractiveRequestParameters interactiveRequestParameters;
    private String verifier;
    private String state;
    private PublicClientApplication publicClientApplication;
    private URL authorizationUrl;

    InteractiveRequest(InteractiveRequestParameters interactiveRequestParameters, AtomicReference<CompletableFuture<IAuthenticationResult>> atomicReference, PublicClientApplication publicClientApplication, RequestContext requestContext) {
        super(publicClientApplication, null, requestContext);
        this.interactiveRequestParameters = interactiveRequestParameters;
        this.futureReference = atomicReference;
        this.publicClientApplication = publicClientApplication;
        this.validateRedirectUrl(interactiveRequestParameters.redirectUri());
    }

    URL authorizationUrl() {
        if (this.authorizationUrl == null) {
            this.authorizationUrl = this.createAuthorizationUrl();
        }
        return this.authorizationUrl;
    }

    private void validateRedirectUrl(URI uRI) {
        InetAddress inetAddress;
        String string = uRI.getHost();
        String string2 = uRI.getScheme();
        if (string2 == null || !string2.equals("http")) {
            throw new MsalClientException(String.format("Only http://localhost or http://localhost:port is supported for the redirect URI of an interactive request using a browser, but \"%s\" was found. For more information about redirect URI formats, see https://aka.ms/msal4j-interactive-request", string2), "loopback_redirect_uri");
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new MsalClientException(String.format("Unknown host exception for host \"%s\". For more information about redirect URI formats, see https://aka.ms/msal4j-interactive-request", string), "loopback_redirect_uri");
        }
        if (inetAddress == null || !inetAddress.isLoopbackAddress()) {
            throw new MsalClientException("Only loopback redirect URI is supported for interactive requests. For more information about redirect URI formats, see https://aka.ms/msal4j-interactive-request", "loopback_redirect_uri");
        }
    }

    private URL createAuthorizationUrl() {
        AuthorizationRequestUrlParameters.Builder builder = AuthorizationRequestUrlParameters.builder(this.interactiveRequestParameters.redirectUri().toString(), this.interactiveRequestParameters.scopes()).prompt(this.interactiveRequestParameters.prompt()).claimsChallenge(this.interactiveRequestParameters.claimsChallenge()).loginHint(this.interactiveRequestParameters.loginHint()).domainHint(this.interactiveRequestParameters.domainHint()).correlationId(this.publicClientApplication.correlationId()).instanceAware(this.interactiveRequestParameters.instanceAware()).extraQueryParameters(this.interactiveRequestParameters.extraQueryParameters());
        this.addPkceAndState(builder);
        AuthorizationRequestUrlParameters authorizationRequestUrlParameters = builder.build();
        return this.publicClientApplication.getAuthorizationRequestUrl(authorizationRequestUrlParameters);
    }

    private void addPkceAndState(AuthorizationRequestUrlParameters.Builder builder) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[32];
        secureRandom.nextBytes(byArray);
        this.verifier = Base64.getUrlEncoder().withoutPadding().encodeToString(byArray);
        this.state = UUID.randomUUID().toString() + UUID.randomUUID().toString();
        builder.codeChallenge(StringHelper.createBase64EncodedSha256Hash(this.verifier)).codeChallengeMethod("S256").state(this.state);
    }

    AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference() {
        return this.futureReference;
    }

    InteractiveRequestParameters interactiveRequestParameters() {
        return this.interactiveRequestParameters;
    }

    String verifier() {
        return this.verifier;
    }

    String state() {
        return this.state;
    }
}

