/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.Serializable;
import java.text.ParseException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;

class IdToken
implements Serializable {
    static final String ISSUER = "iss";
    static final String SUBJECT = "sub";
    static final String AUDIENCE = "aud";
    static final String EXPIRATION_TIME = "exp";
    static final String ISSUED_AT = "issuedAt";
    static final String NOT_BEFORE = "nbf";
    static final String NAME = "name";
    static final String PREFERRED_USERNAME = "preferred_username";
    static final String OBJECT_IDENTIFIER = "oid";
    static final String TENANT_IDENTIFIER = "tid";
    static final String UPN = "upn";
    static final String UNIQUE_NAME = "unique_name";
    @JsonProperty(value="iss")
    protected String issuer;
    @JsonProperty(value="sub")
    protected String subject;
    @JsonProperty(value="aud")
    protected String audience;
    @JsonProperty(value="exp")
    protected Long expirationTime;
    @JsonProperty(value="iat")
    protected Long issuedAt;
    @JsonProperty(value="nbf")
    protected Long notBefore;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="preferred_username")
    protected String preferredUsername;
    @JsonProperty(value="oid")
    protected String objectIdentifier;
    @JsonProperty(value="tid")
    protected String tenantIdentifier;
    @JsonProperty(value="upn")
    protected String upn;
    @JsonProperty(value="unique_name")
    protected String uniqueName;

    IdToken() {
    }

    static IdToken createFromJWTClaims(JWTClaimsSet jWTClaimsSet) throws ParseException {
        IdToken idToken = new IdToken();
        idToken.issuer = jWTClaimsSet.getStringClaim(ISSUER);
        idToken.subject = jWTClaimsSet.getStringClaim(SUBJECT);
        idToken.audience = jWTClaimsSet.getStringClaim(AUDIENCE);
        idToken.expirationTime = jWTClaimsSet.getLongClaim(EXPIRATION_TIME);
        idToken.issuedAt = jWTClaimsSet.getLongClaim(ISSUED_AT);
        idToken.notBefore = jWTClaimsSet.getLongClaim(NOT_BEFORE);
        idToken.name = jWTClaimsSet.getStringClaim(NAME);
        idToken.preferredUsername = jWTClaimsSet.getStringClaim(PREFERRED_USERNAME);
        idToken.objectIdentifier = jWTClaimsSet.getStringClaim(OBJECT_IDENTIFIER);
        idToken.tenantIdentifier = jWTClaimsSet.getStringClaim(TENANT_IDENTIFIER);
        idToken.upn = jWTClaimsSet.getStringClaim(UPN);
        idToken.uniqueName = jWTClaimsSet.getStringClaim(UNIQUE_NAME);
        return idToken;
    }
}

