/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IEnvironmentVariables;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class IMDSManagedIdentitySource
extends AbstractManagedIdentitySource {
    private static final Logger LOG = LoggerFactory.getLogger(IMDSManagedIdentitySource.class);
    private static final URI DEFAULT_IMDS_ENDPOINT;
    private static final String IMDS_TOKEN_PATH = "/metadata/identity/oauth2/token";
    private static final String IMDS_API_VERSION = "2018-02-01";
    private URI imdsEndpoint;

    public IMDSManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        super(msalRequest, serviceBundle, ManagedIdentitySourceType.IMDS);
        ManagedIdentityParameters managedIdentityParameters = (ManagedIdentityParameters)msalRequest.requestContext().apiParameters();
        IEnvironmentVariables iEnvironmentVariables = IMDSManagedIdentitySource.getEnvironmentVariables();
        if (!StringHelper.isNullOrBlank(iEnvironmentVariables.getEnvironmentVariable("AZURE_POD_IDENTITY_AUTHORITY_HOST"))) {
            LOG.info(String.format("[Managed Identity] Environment variable AZURE_POD_IDENTITY_AUTHORITY_HOST for IMDS returned endpoint: %s", iEnvironmentVariables.getEnvironmentVariable("AZURE_POD_IDENTITY_AUTHORITY_HOST")));
            try {
                this.imdsEndpoint = new URI(iEnvironmentVariables.getEnvironmentVariable("AZURE_POD_IDENTITY_AUTHORITY_HOST"));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
            StringBuilder stringBuilder = new StringBuilder(iEnvironmentVariables.getEnvironmentVariable("AZURE_POD_IDENTITY_AUTHORITY_HOST"));
            stringBuilder.append("//metadata/identity/oauth2/token");
            try {
                this.imdsEndpoint = new URI(stringBuilder.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new MsalServiceException(String.format("[Managed Identity] The environment variable %s contains an invalid Uri %s in %s managed identity source.", new Object[]{"AZURE_POD_IDENTITY_AUTHORITY_HOST", stringBuilder.toString(), ManagedIdentitySourceType.IMDS}), "invalid_managed_identity_endpoint", ManagedIdentitySourceType.IMDS);
            }
        }
        LOG.info("[Managed Identity] Unable to find AZURE_POD_IDENTITY_AUTHORITY_HOST environment variable for IMDS, using the default endpoint.");
        this.imdsEndpoint = DEFAULT_IMDS_ENDPOINT;
        LOG.info(String.format("[Managed Identity] Creating IMDS managed identity source. Endpoint URI: %s", this.imdsEndpoint));
    }

    @Override
    public void createManagedIdentityRequest(String string) {
        this.managedIdentityRequest.baseEndpoint = this.imdsEndpoint;
        this.managedIdentityRequest.method = HttpMethod.GET;
        this.managedIdentityRequest.headers = new HashMap<String, String>();
        this.managedIdentityRequest.headers.put("Metadata", "true");
        this.managedIdentityRequest.queryParameters = new HashMap<String, List<String>>();
        this.managedIdentityRequest.queryParameters.put("api-version", Collections.singletonList(IMDS_API_VERSION));
        this.managedIdentityRequest.queryParameters.put("resource", Collections.singletonList(string));
        String string2 = this.getManagedIdentityUserAssignedClientId();
        String string3 = this.getManagedIdentityUserAssignedResourceId();
        if (!StringHelper.isNullOrBlank(string2)) {
            LOG.info("[Managed Identity] Adding user assigned client id to the request.");
            this.managedIdentityRequest.queryParameters.put("client_id", Collections.singletonList(string2));
        }
        if (!StringHelper.isNullOrBlank(string3)) {
            LOG.info("[Managed Identity] Adding user assigned resource id to the request.");
            this.managedIdentityRequest.queryParameters.put("mi_res_id", Collections.singletonList(string3));
        }
    }

    @Override
    public ManagedIdentityResponse handleResponse(ManagedIdentityParameters managedIdentityParameters, IHttpResponse iHttpResponse) {
        String string = iHttpResponse.statusCode() == 400 ? "[Managed Identity] Authentication unavailable. The requested identity has not been assigned to this resource." : (iHttpResponse.statusCode() == 502 || iHttpResponse.statusCode() == 504 ? "[Managed Identity] Authentication unavailable. The request failed due to a gateway error." : null);
        if (string != null) {
            String string2 = IMDSManagedIdentitySource.createRequestFailedMessage(iHttpResponse, string);
            String string3 = this.getMessageFromErrorResponse(iHttpResponse);
            string2 = string2 + " " + string3;
            LOG.error(String.format("Error message: %s Http status code: %s", string2, iHttpResponse.statusCode()));
            throw new MsalServiceException(string2, "managed_identity_request_failed", ManagedIdentitySourceType.IMDS);
        }
        return super.handleResponse(managedIdentityParameters, iHttpResponse);
    }

    private static String createRequestFailedMessage(IHttpResponse iHttpResponse, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringHelper.isNullOrBlank(string) ? "[Managed Identity] Service request failed." : string);
        stringBuilder.append("Status: ");
        stringBuilder.append(iHttpResponse.statusCode());
        if (iHttpResponse.body() != null) {
            stringBuilder.append("Content:").append(iHttpResponse.body());
        }
        stringBuilder.append("Headers:");
        for (String string2 : iHttpResponse.headers().keySet()) {
            stringBuilder.append(string2).append(iHttpResponse.headers().get(string2));
        }
        return stringBuilder.toString();
    }

    static {
        try {
            DEFAULT_IMDS_ENDPOINT = new URI("http://169.254.169.254/metadata/identity/oauth2/token");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MsalServiceException(uRISyntaxException.getMessage(), "invalid_managed_identity_endpoint", ManagedIdentitySourceType.IMDS);
        }
    }
}

