/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URL;
import java.util.concurrent.CompletableFuture;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AccountCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IdToken;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequestParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserNamePasswordParameters;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;

public interface IBroker {
    default public CompletableFuture<IAuthenticationResult> acquireToken(PublicClientApplication publicClientApplication, SilentParameters silentParameters) {
        throw new MsalClientException("Broker implementation missing", "missing_broker");
    }

    default public CompletableFuture<IAuthenticationResult> acquireToken(PublicClientApplication publicClientApplication, InteractiveRequestParameters interactiveRequestParameters) {
        throw new MsalClientException("Broker implementation missing", "missing_broker");
    }

    default public CompletableFuture<IAuthenticationResult> acquireToken(PublicClientApplication publicClientApplication, UserNamePasswordParameters userNamePasswordParameters) {
        throw new MsalClientException("Broker implementation missing", "missing_broker");
    }

    default public void removeAccount(PublicClientApplication publicClientApplication, IAccount iAccount) throws MsalClientException {
        throw new MsalClientException("Broker implementation missing", "missing_broker");
    }

    default public boolean isBrokerAvailable() {
        throw new MsalClientException("Broker implementation missing", "missing_broker");
    }

    default public IAuthenticationResult parseBrokerAuthResult(String string, String string2, String string3, String string4, String string5, long l2, boolean bl2) {
        AuthenticationResult.AuthenticationResultBuilder authenticationResultBuilder = AuthenticationResult.builder();
        try {
            if (string2 != null) {
                authenticationResultBuilder.idToken(string2);
                if (string4 != null) {
                    String string6 = JWTParser.parse(string2).getParsedParts()[1].decodeToString();
                    authenticationResultBuilder.accountCacheEntity(AccountCacheEntity.create(string5, Authority.createAuthority(new URL(string)), JsonHelper.convertJsonToObject(string6, IdToken.class), null));
                }
            }
            if (string3 != null) {
                authenticationResultBuilder.accessToken(string3);
                authenticationResultBuilder.expiresOn(l2);
            }
            authenticationResultBuilder.isPopAuthorization(bl2);
        }
        catch (Exception exception) {
            throw new MsalClientException(String.format("Exception when converting broker result to MSAL Java AuthenticationResult: %s", exception.getMessage()), "brokers_package_error");
        }
        return authenticationResultBuilder.build();
    }
}

