/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpEvent;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.LogHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalThrottlingException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TelemetryHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TelemetryManager;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ThrottlingCache;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.XmsClientTelemetryInfo;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class HttpHelper
implements IHttpHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);
    public static final String RETRY_AFTER_HEADER = "Retry-After";
    public static final int RETRY_NUM = 2;
    public static final int RETRY_DELAY_MS = 1000;
    public static final int HTTP_STATUS_200 = 200;
    public static final int HTTP_STATUS_400 = 400;
    public static final int HTTP_STATUS_429 = 429;
    public static final int HTTP_STATUS_500 = 500;
    private IHttpClient httpClient;

    HttpHelper(IHttpClient iHttpClient) {
        this.httpClient = iHttpClient;
    }

    @Override
    public IHttpResponse executeHttpRequest(HttpRequest httpRequest, RequestContext requestContext, ServiceBundle serviceBundle) {
        IHttpResponse iHttpResponse;
        this.checkForThrottling(requestContext);
        HttpEvent httpEvent = new HttpEvent();
        try (TelemetryHelper telemetryHelper = serviceBundle.getTelemetryManager().createTelemetryHelper(requestContext.telemetryRequestId(), requestContext.clientId(), httpEvent, false);){
            this.addRequestInfoToTelemetry(httpRequest, httpEvent);
            try {
                iHttpResponse = this.executeHttpRequestWithRetries(httpRequest, this.httpClient);
            }
            catch (Exception exception) {
                httpEvent.setOauthErrorCode("unknown");
                throw new MsalClientException(exception);
            }
            this.addResponseInfoToTelemetry(iHttpResponse, httpEvent);
            if (iHttpResponse.headers() != null) {
                HttpHelper.verifyReturnedCorrelationId(httpRequest, iHttpResponse);
            }
        }
        this.processThrottlingInstructions(iHttpResponse, requestContext);
        return iHttpResponse;
    }

    IHttpResponse executeHttpRequest(HttpRequest httpRequest, RequestContext requestContext, TelemetryManager telemetryManager, IHttpClient iHttpClient) {
        IHttpResponse iHttpResponse;
        this.checkForThrottling(requestContext);
        HttpEvent httpEvent = new HttpEvent();
        try (TelemetryHelper telemetryHelper = telemetryManager.createTelemetryHelper(requestContext.telemetryRequestId(), requestContext.clientId(), httpEvent, false);){
            this.addRequestInfoToTelemetry(httpRequest, httpEvent);
            try {
                iHttpResponse = this.executeHttpRequestWithRetries(httpRequest, iHttpClient);
            }
            catch (Exception exception) {
                httpEvent.setOauthErrorCode("unknown");
                throw new MsalClientException(exception);
            }
            this.addResponseInfoToTelemetry(iHttpResponse, httpEvent);
            if (iHttpResponse.headers() != null) {
                HttpHelper.verifyReturnedCorrelationId(httpRequest, iHttpResponse);
            }
        }
        this.processThrottlingInstructions(iHttpResponse, requestContext);
        return iHttpResponse;
    }

    private String getRequestThumbprint(RequestContext requestContext) {
        Serializable serializable;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(requestContext.clientId() + ".");
        stringBuilder.append(requestContext.authority() + ".");
        IAcquireTokenParameters iAcquireTokenParameters = requestContext.apiParameters();
        if (iAcquireTokenParameters instanceof SilentParameters && (serializable = ((SilentParameters)iAcquireTokenParameters).account()) != null) {
            stringBuilder.append(serializable.homeAccountId() + ".");
        }
        serializable = new TreeSet<String>(iAcquireTokenParameters.scopes());
        stringBuilder.append(String.join((CharSequence)" ", (Iterable<? extends CharSequence>)((Object)serializable)));
        return StringHelper.createSha256Hash(stringBuilder.toString());
    }

    boolean isRetryable(IHttpResponse iHttpResponse) {
        return iHttpResponse.statusCode() >= 500 && this.getRetryAfterHeader(iHttpResponse) == null;
    }

    IHttpResponse executeHttpRequestWithRetries(HttpRequest httpRequest, IHttpClient iHttpClient) throws Exception {
        IHttpResponse iHttpResponse = null;
        for (int i2 = 0; i2 < 2 && this.isRetryable(iHttpResponse = iHttpClient.send(httpRequest)); ++i2) {
            Thread.sleep(1000L);
        }
        return iHttpResponse;
    }

    private void checkForThrottling(RequestContext requestContext) {
        String string;
        long l2;
        if (requestContext.clientApplication() instanceof PublicClientApplication && requestContext.apiParameters() != null && (l2 = ThrottlingCache.retryInMs(string = this.getRequestThumbprint(requestContext))) > 0L) {
            throw new MsalThrottlingException(l2);
        }
    }

    private void processThrottlingInstructions(IHttpResponse iHttpResponse, RequestContext requestContext) {
        if (requestContext.clientApplication() instanceof PublicClientApplication) {
            Long l2 = null;
            Integer n2 = this.getRetryAfterHeader(iHttpResponse);
            if (n2 != null) {
                l2 = System.currentTimeMillis() + (long)(n2 * 1000);
            } else if (iHttpResponse.statusCode() == 429 || iHttpResponse.statusCode() >= 500) {
                l2 = System.currentTimeMillis() + (long)(ThrottlingCache.DEFAULT_THROTTLING_TIME_SEC * 1000);
            }
            if (l2 != null) {
                ThrottlingCache.set(this.getRequestThumbprint(requestContext), l2);
            }
        }
    }

    private Integer getRetryAfterHeader(IHttpResponse iHttpResponse) {
        if (iHttpResponse.headers() != null) {
            TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            treeMap.putAll(iHttpResponse.headers());
            if (treeMap.containsKey(RETRY_AFTER_HEADER) && ((List)treeMap.get(RETRY_AFTER_HEADER)).size() == 1) {
                try {
                    int n2 = Integer.parseInt((String)((List)treeMap.get(RETRY_AFTER_HEADER)).get(0));
                    if (n2 > 0 && n2 <= 3600) {
                        return n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    log.warn("Failed to parse value of Retry-After header - NumberFormatException");
                }
            }
        }
        return null;
    }

    private void addRequestInfoToTelemetry(HttpRequest httpRequest, HttpEvent httpEvent) {
        try {
            httpEvent.setHttpPath(httpRequest.url().toURI());
            httpEvent.setHttpMethod(httpRequest.httpMethod().toString());
            if (!StringHelper.isBlank(httpRequest.url().getQuery())) {
                httpEvent.setQueryParameters(httpRequest.url().getQuery());
            }
        }
        catch (Exception exception) {
            String string = httpRequest.headerValue("client-request-id");
            log.warn(LogHelper.createMessage("Setting URL telemetry fields failed: " + LogHelper.getPiiScrubbedDetails(exception), string != null ? string : ""));
        }
    }

    private void addResponseInfoToTelemetry(IHttpResponse iHttpResponse, HttpEvent httpEvent) {
        XmsClientTelemetryInfo xmsClientTelemetryInfo;
        String string;
        String string2;
        httpEvent.setHttpResponseStatus(iHttpResponse.statusCode());
        Map<String, List<String>> map = iHttpResponse.headers();
        String string3 = HttpUtils.headerValue(map, "User-Agent");
        if (!StringHelper.isBlank(string3)) {
            httpEvent.setUserAgent(string3);
        }
        if (!StringHelper.isBlank(string2 = HttpUtils.headerValue(map, "x-ms-request-id"))) {
            httpEvent.setRequestIdHeader(string2);
        }
        if ((string = HttpUtils.headerValue(map, "x-ms-clitelem")) != null && (xmsClientTelemetryInfo = XmsClientTelemetryInfo.parseXmsTelemetryInfo(string)) != null) {
            httpEvent.setXmsClientTelemetryInfo(xmsClientTelemetryInfo);
        }
    }

    private static void verifyReturnedCorrelationId(HttpRequest httpRequest, IHttpResponse iHttpResponse) {
        String string = httpRequest.headerValue("client-request-id");
        String string2 = HttpUtils.headerValue(iHttpResponse.headers(), "client-request-id");
        if (StringHelper.isBlank(string2) || !string2.equals(string)) {
            String string3 = LogHelper.createMessage(String.format("Sent (%s) Correlation Id is not same as received (%s).", string, string2), string);
            log.info(string3);
        }
    }
}

