/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IEnvironmentVariables;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityIdType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class CloudShellManagedIdentitySource
extends AbstractManagedIdentitySource {
    private static final Logger LOG = LoggerFactory.getLogger(CloudShellManagedIdentitySource.class);
    private final URI msiEndpoint;

    @Override
    public void createManagedIdentityRequest(String string) {
        this.managedIdentityRequest.baseEndpoint = this.msiEndpoint;
        this.managedIdentityRequest.method = HttpMethod.POST;
        this.managedIdentityRequest.headers = new HashMap<String, String>();
        this.managedIdentityRequest.headers.put("ContentType", "application/x-www-form-urlencoded");
        this.managedIdentityRequest.headers.put("Metadata", "true");
        this.managedIdentityRequest.headers.put("resource", string);
        this.managedIdentityRequest.bodyParameters = new HashMap<String, List<String>>();
        this.managedIdentityRequest.bodyParameters.put("resource", Collections.singletonList(string));
    }

    private CloudShellManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle, URI uRI) {
        super(msalRequest, serviceBundle, ManagedIdentitySourceType.CLOUD_SHELL);
        this.msiEndpoint = uRI;
        ManagedIdentityIdType managedIdentityIdType = ((ManagedIdentityApplication)msalRequest.application()).getManagedIdentityId().getIdType();
        if (managedIdentityIdType != ManagedIdentityIdType.SYSTEM_ASSIGNED) {
            throw new MsalServiceException(String.format("[Managed Identity] User assigned identity is not supported by the %s Managed Identity. To authenticate with the system assigned identity use ManagedIdentityApplication.builder(ManagedIdentityId.systemAssigned()).build().", "cloud shell"), "user_assigned_managed_identity_not_supported", ManagedIdentitySourceType.CLOUD_SHELL);
        }
    }

    static AbstractManagedIdentitySource create(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        IEnvironmentVariables iEnvironmentVariables = CloudShellManagedIdentitySource.getEnvironmentVariables();
        String string = iEnvironmentVariables.getEnvironmentVariable("MSI_ENDPOINT");
        if (StringHelper.isNullOrBlank(string)) {
            LOG.info("[Managed Identity] Cloud shell managed identity is unavailable.");
            return null;
        }
        return new CloudShellManagedIdentitySource(msalRequest, serviceBundle, CloudShellManagedIdentitySource.validateAndGetUri(string));
    }

    private static URI validateAndGetUri(String string) {
        try {
            URI uRI = new URI(string);
            LOG.info(String.format("[Managed Identity] Environment variables validation passed for cloud shell managed identity. Endpoint URI: %s. Creating cloud shell managed identity.", uRI));
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MsalServiceException(String.format("[Managed Identity] The environment variable %s contains an invalid Uri %s in %s managed identity source.", "MSI_ENDPOINT", string, "Cloud Shell"), "invalid_managed_identity_endpoint", ManagedIdentitySourceType.CLOUD_SHELL);
        }
    }
}

