/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.URL;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;

public class CIAMAuthority
extends Authority {
    public static final String CIAM_HOST_SEGMENT = ".ciamlogin.com";
    static final String AUTHORIZATION_ENDPOINT = "oauth2/v2.0/authorize";
    static final String TOKEN_ENDPOINT = "oauth2/v2.0/token";
    static final String DEVICE_CODE_ENDPOINT = "oauth2/v2.0/devicecode";
    private static final String CIAM_AUTHORITY_FORMAT = "https://%s/%s/";
    private static final String DEVICE_CODE_ENDPOINT_FORMAT = "https://%s/%s/oauth2/v2.0/devicecode";
    private static final String CIAM_AUTHORIZATION_ENDPOINT_FORMAT = "https://%s/%s/oauth2/v2.0/authorize";
    private static final String CIAM_TOKEN_ENDPOINT_FORMAT = "https://%s/%s/oauth2/v2.0/token";

    CIAMAuthority(URL uRL) throws MalformedURLException {
        super(CIAMAuthority.transformAuthority(uRL), AuthorityType.CIAM);
        this.setAuthorityProperties();
        this.authority = String.format(CIAM_AUTHORITY_FORMAT, this.host, this.tenant);
    }

    protected static URL transformAuthority(URL uRL) throws MalformedURLException {
        String string = uRL.getHost() + uRL.getPath();
        String string2 = uRL.toString();
        if (uRL.getPath().equals("/")) {
            int n2 = string.indexOf(CIAM_HOST_SEGMENT);
            String string3 = string.substring(0, n2);
            string2 = uRL + string3 + ".onmicrosoft.com/";
        }
        return new URL(string2);
    }

    private void setAuthorityProperties() {
        this.authorizationEndpoint = String.format(CIAM_AUTHORIZATION_ENDPOINT_FORMAT, this.host, this.tenant);
        this.tokenEndpoint = String.format(CIAM_TOKEN_ENDPOINT_FORMAT, this.host, this.tenant);
        this.deviceCodeEndpoint = String.format(DEVICE_CODE_ENDPOINT_FORMAT, this.host, this.tenant);
        this.selfSignedJwtAudience = this.tokenEndpoint;
    }
}

