/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;

public class AuthorizationCodeParameters
implements IAcquireTokenParameters {
    @NonNull
    private String authorizationCode;
    @NonNull
    private URI redirectUri;
    private Set<String> scopes;
    private ClaimsRequest claims;
    private String codeVerifier;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;

    private static AuthorizationCodeParametersBuilder builder() {
        return new AuthorizationCodeParametersBuilder();
    }

    public static AuthorizationCodeParametersBuilder builder(String string, URI uRI) {
        ParameterValidationUtils.validateNotBlank("authorizationCode", string);
        return AuthorizationCodeParameters.builder().authorizationCode(string).redirectUri(uRI);
    }

    @NonNull
    public String authorizationCode() {
        return this.authorizationCode;
    }

    @NonNull
    public URI redirectUri() {
        return this.redirectUri;
    }

    @Override
    public Set<String> scopes() {
        return this.scopes;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    public String codeVerifier() {
        return this.codeVerifier;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    private AuthorizationCodeParameters(@NonNull String string, @NonNull URI uRI, Set<String> set, ClaimsRequest claimsRequest, String string2, Map<String, String> map, Map<String, String> map2, String string3) {
        if (string == null) {
            throw new NullPointerException("authorizationCode is marked @NonNull but is null");
        }
        if (uRI == null) {
            throw new NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.authorizationCode = string;
        this.redirectUri = uRI;
        this.scopes = set;
        this.claims = claimsRequest;
        this.codeVerifier = string2;
        this.extraHttpHeaders = map;
        this.extraQueryParameters = map2;
        this.tenant = string3;
    }

    public static class AuthorizationCodeParametersBuilder {
        private String authorizationCode;
        private URI redirectUri;
        private Set<String> scopes;
        private ClaimsRequest claims;
        private String codeVerifier;
        private Map<String, String> extraHttpHeaders;
        private Map<String, String> extraQueryParameters;
        private String tenant;

        AuthorizationCodeParametersBuilder() {
        }

        public AuthorizationCodeParametersBuilder authorizationCode(String string) {
            this.authorizationCode = string;
            return this;
        }

        public AuthorizationCodeParametersBuilder redirectUri(URI uRI) {
            this.redirectUri = uRI;
            return this;
        }

        public AuthorizationCodeParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public AuthorizationCodeParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public AuthorizationCodeParametersBuilder codeVerifier(String string) {
            this.codeVerifier = string;
            return this;
        }

        public AuthorizationCodeParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public AuthorizationCodeParametersBuilder extraQueryParameters(Map<String, String> map) {
            this.extraQueryParameters = map;
            return this;
        }

        public AuthorizationCodeParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public AuthorizationCodeParameters build() {
            return new AuthorizationCodeParameters(this.authorizationCode, this.redirectUri, this.scopes, this.claims, this.codeVerifier, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        public String toString() {
            return "AuthorizationCodeParameters.AuthorizationCodeParametersBuilder(authorizationCode=" + this.authorizationCode + ", redirectUri=" + this.redirectUri + ", scopes=" + this.scopes + ", claims=" + this.claims + ", codeVerifier=" + this.codeVerifier + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }
}

