/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.text.ParseException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AccountCacheEntity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultMetadata;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITenantProfile;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IdToken;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TenantProfile;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;

final class AuthenticationResult
implements IAuthenticationResult {
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final long expiresOn;
    private final long extExpiresOn;
    private final String refreshToken;
    private final Long refreshOn;
    private final String familyId;
    private final String idToken;
    private final AtomicReference<Object> idTokenObject = new AtomicReference();
    private final AccountCacheEntity accountCacheEntity;
    private final AtomicReference<Object> account = new AtomicReference();
    private final AtomicReference<Object> tenantProfile = new AtomicReference();
    private String environment;
    private final AtomicReference<Object> expiresOnDate = new AtomicReference();
    private final String scopes;
    private final AuthenticationResultMetadata metadata;
    private final Boolean isPopAuthorization;

    private IdToken getIdTokenObj() {
        if (StringHelper.isBlank(this.idToken)) {
            return null;
        }
        try {
            String string = JWTParser.parse(this.idToken).getParsedParts()[1].decodeToString();
            return JsonHelper.convertJsonToObject(string, IdToken.class);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    private IAccount getAccount() {
        if (this.accountCacheEntity == null) {
            return null;
        }
        return this.accountCacheEntity.toAccount();
    }

    private ITenantProfile getTenantProfile() {
        if (StringHelper.isBlank(this.idToken)) {
            return null;
        }
        try {
            return new TenantProfile(JWTParser.parse(this.idToken).getJWTClaimsSet().getClaims(), this.getAccount().environment());
        }
        catch (ParseException parseException) {
            throw new MsalClientException("Cached JWT could not be parsed: " + parseException.getMessage(), "invalid_jwt");
        }
    }

    private static AuthenticationResultMetadata $default$metadata() {
        return new AuthenticationResultMetadata();
    }

    AuthenticationResult(String string, long l2, long l3, String string2, Long l4, String string3, String string4, AccountCacheEntity accountCacheEntity, String string5, String string6, AuthenticationResultMetadata authenticationResultMetadata, Boolean bl2) {
        this.accessToken = string;
        this.expiresOn = l2;
        this.extExpiresOn = l3;
        this.refreshToken = string2;
        this.refreshOn = l4;
        this.familyId = string3;
        this.idToken = string4;
        this.accountCacheEntity = accountCacheEntity;
        this.environment = string5;
        this.scopes = string6;
        this.metadata = authenticationResultMetadata;
        this.isPopAuthorization = bl2;
    }

    public static AuthenticationResultBuilder builder() {
        return new AuthenticationResultBuilder();
    }

    @Override
    public String accessToken() {
        return this.accessToken;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public Long refreshOn() {
        return this.refreshOn;
    }

    @Override
    public String idToken() {
        return this.idToken;
    }

    @Override
    public String environment() {
        return this.environment;
    }

    @Override
    public String scopes() {
        return this.scopes;
    }

    @Override
    public AuthenticationResultMetadata metadata() {
        return this.metadata;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AuthenticationResult)) {
            return false;
        }
        AuthenticationResult authenticationResult = (AuthenticationResult)object;
        String string = this.accessToken();
        String string2 = authenticationResult.accessToken();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        if (this.expiresOn() != authenticationResult.expiresOn()) {
            return false;
        }
        if (this.extExpiresOn() != authenticationResult.extExpiresOn()) {
            return false;
        }
        String string3 = this.refreshToken();
        String string4 = authenticationResult.refreshToken();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Long l2 = this.refreshOn();
        Long l3 = authenticationResult.refreshOn();
        if (l2 == null ? l3 != null : !((Object)l2).equals(l3)) {
            return false;
        }
        String string5 = this.familyId();
        String string6 = authenticationResult.familyId();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.idToken();
        String string8 = authenticationResult.idToken();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        IdToken idToken = this.idTokenObject();
        IdToken idToken2 = authenticationResult.idTokenObject();
        if (idToken == null ? idToken2 != null : !idToken.equals(idToken2)) {
            return false;
        }
        AccountCacheEntity accountCacheEntity = this.accountCacheEntity();
        AccountCacheEntity accountCacheEntity2 = authenticationResult.accountCacheEntity();
        if (accountCacheEntity == null ? accountCacheEntity2 != null : !((Object)accountCacheEntity).equals(accountCacheEntity2)) {
            return false;
        }
        IAccount iAccount = this.account();
        IAccount iAccount2 = authenticationResult.account();
        if (iAccount == null ? iAccount2 != null : !iAccount.equals(iAccount2)) {
            return false;
        }
        ITenantProfile iTenantProfile = this.tenantProfile();
        ITenantProfile iTenantProfile2 = authenticationResult.tenantProfile();
        if (iTenantProfile == null ? iTenantProfile2 != null : !iTenantProfile.equals(iTenantProfile2)) {
            return false;
        }
        String string9 = this.environment();
        String string10 = authenticationResult.environment();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        Date date = this.expiresOnDate();
        Date date2 = authenticationResult.expiresOnDate();
        if (date == null ? date2 != null : !((Object)date).equals(date2)) {
            return false;
        }
        String string11 = this.scopes();
        String string12 = authenticationResult.scopes();
        if (string11 == null ? string12 != null : !string11.equals(string12)) {
            return false;
        }
        AuthenticationResultMetadata authenticationResultMetadata = this.metadata();
        AuthenticationResultMetadata authenticationResultMetadata2 = authenticationResult.metadata();
        if (authenticationResultMetadata == null ? authenticationResultMetadata2 != null : !authenticationResultMetadata.equals(authenticationResultMetadata2)) {
            return false;
        }
        Boolean bl2 = this.isPopAuthorization();
        Boolean bl3 = authenticationResult.isPopAuthorization();
        return !(bl2 == null ? bl3 != null : !((Object)bl2).equals(bl3));
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        String string = this.accessToken();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        long l2 = this.expiresOn();
        n3 = n3 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.extExpiresOn();
        n3 = n3 * 59 + (int)(l3 >>> 32 ^ l3);
        String string2 = this.refreshToken();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        Long l4 = this.refreshOn();
        n3 = n3 * 59 + (l4 == null ? 43 : ((Object)l4).hashCode());
        String string3 = this.familyId();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.idToken();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        IdToken idToken = this.idTokenObject();
        n3 = n3 * 59 + (idToken == null ? 43 : idToken.hashCode());
        AccountCacheEntity accountCacheEntity = this.accountCacheEntity();
        n3 = n3 * 59 + (accountCacheEntity == null ? 43 : ((Object)accountCacheEntity).hashCode());
        IAccount iAccount = this.account();
        n3 = n3 * 59 + (iAccount == null ? 43 : iAccount.hashCode());
        ITenantProfile iTenantProfile = this.tenantProfile();
        n3 = n3 * 59 + (iTenantProfile == null ? 43 : iTenantProfile.hashCode());
        String string5 = this.environment();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        Date date = this.expiresOnDate();
        n3 = n3 * 59 + (date == null ? 43 : ((Object)date).hashCode());
        String string6 = this.scopes();
        n3 = n3 * 59 + (string6 == null ? 43 : string6.hashCode());
        AuthenticationResultMetadata authenticationResultMetadata = this.metadata();
        n3 = n3 * 59 + (authenticationResultMetadata == null ? 43 : authenticationResultMetadata.hashCode());
        Boolean bl2 = this.isPopAuthorization();
        n3 = n3 * 59 + (bl2 == null ? 43 : ((Object)bl2).hashCode());
        return n3;
    }

    long expiresOn() {
        return this.expiresOn;
    }

    long extExpiresOn() {
        return this.extExpiresOn;
    }

    String familyId() {
        return this.familyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IdToken idTokenObject() {
        Object object = this.idTokenObject.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.idTokenObject;
            synchronized (atomicReference) {
                object = this.idTokenObject.get();
                if (object == null) {
                    IdToken idToken = this.getIdTokenObj();
                    object = idToken == null ? this.idTokenObject : idToken;
                    this.idTokenObject.set(object);
                }
            }
        }
        return (IdToken)(object == this.idTokenObject ? null : object);
    }

    AccountCacheEntity accountCacheEntity() {
        return this.accountCacheEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAccount account() {
        Object object = this.account.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.account;
            synchronized (atomicReference) {
                object = this.account.get();
                if (object == null) {
                    IAccount iAccount = this.getAccount();
                    object = iAccount == null ? this.account : iAccount;
                    this.account.set(object);
                }
            }
        }
        return (IAccount)(object == this.account ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITenantProfile tenantProfile() {
        Object object = this.tenantProfile.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.tenantProfile;
            synchronized (atomicReference) {
                object = this.tenantProfile.get();
                if (object == null) {
                    ITenantProfile iTenantProfile = this.getTenantProfile();
                    object = iTenantProfile == null ? this.tenantProfile : iTenantProfile;
                    this.tenantProfile.set(object);
                }
            }
        }
        return (ITenantProfile)(object == this.tenantProfile ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date expiresOnDate() {
        Object object = this.expiresOnDate.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.expiresOnDate;
            synchronized (atomicReference) {
                object = this.expiresOnDate.get();
                if (object == null) {
                    Date date = new Date(this.expiresOn * 1000L);
                    object = date == null ? this.expiresOnDate : date;
                    this.expiresOnDate.set(object);
                }
            }
        }
        return (Date)(object == this.expiresOnDate ? null : object);
    }

    Boolean isPopAuthorization() {
        return this.isPopAuthorization;
    }

    public static class AuthenticationResultBuilder {
        private String accessToken;
        private long expiresOn;
        private long extExpiresOn;
        private String refreshToken;
        private Long refreshOn;
        private String familyId;
        private String idToken;
        private AccountCacheEntity accountCacheEntity;
        private String environment;
        private String scopes;
        private boolean metadata$set;
        private AuthenticationResultMetadata metadata;
        private Boolean isPopAuthorization;

        AuthenticationResultBuilder() {
        }

        public AuthenticationResultBuilder accessToken(String string) {
            this.accessToken = string;
            return this;
        }

        public AuthenticationResultBuilder expiresOn(long l2) {
            this.expiresOn = l2;
            return this;
        }

        public AuthenticationResultBuilder extExpiresOn(long l2) {
            this.extExpiresOn = l2;
            return this;
        }

        public AuthenticationResultBuilder refreshToken(String string) {
            this.refreshToken = string;
            return this;
        }

        public AuthenticationResultBuilder refreshOn(Long l2) {
            this.refreshOn = l2;
            return this;
        }

        public AuthenticationResultBuilder familyId(String string) {
            this.familyId = string;
            return this;
        }

        public AuthenticationResultBuilder idToken(String string) {
            this.idToken = string;
            return this;
        }

        public AuthenticationResultBuilder accountCacheEntity(AccountCacheEntity accountCacheEntity) {
            this.accountCacheEntity = accountCacheEntity;
            return this;
        }

        public AuthenticationResultBuilder environment(String string) {
            this.environment = string;
            return this;
        }

        public AuthenticationResultBuilder scopes(String string) {
            this.scopes = string;
            return this;
        }

        public AuthenticationResultBuilder metadata(AuthenticationResultMetadata authenticationResultMetadata) {
            this.metadata = authenticationResultMetadata;
            this.metadata$set = true;
            return this;
        }

        public AuthenticationResultBuilder isPopAuthorization(Boolean bl2) {
            this.isPopAuthorization = bl2;
            return this;
        }

        public AuthenticationResult build() {
            AuthenticationResultMetadata authenticationResultMetadata = this.metadata;
            if (!this.metadata$set) {
                authenticationResultMetadata = AuthenticationResult.$default$metadata();
            }
            return new AuthenticationResult(this.accessToken, this.expiresOn, this.extExpiresOn, this.refreshToken, this.refreshOn, this.familyId, this.idToken, this.accountCacheEntity, this.environment, this.scopes, authenticationResultMetadata, this.isPopAuthorization);
        }

        public String toString() {
            return "AuthenticationResult.AuthenticationResultBuilder(accessToken=" + this.accessToken + ", expiresOn=" + this.expiresOn + ", extExpiresOn=" + this.extExpiresOn + ", refreshToken=" + this.refreshToken + ", refreshOn=" + this.refreshOn + ", familyId=" + this.familyId + ", idToken=" + this.idToken + ", accountCacheEntity=" + this.accountCacheEntity + ", environment=" + this.environment + ", scopes=" + this.scopes + ", metadata=" + this.metadata + ", isPopAuthorization=" + this.isPopAuthorization + ")";
        }
    }
}

