/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URI;
import java.util.Locale;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Event;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

class ApiEvent
extends Event {
    private static final String API_ID_KEY = "msal.api_id";
    private static final String AUTHORITY_KEY = "msal.authority";
    private static final String AUTHORITY_TYPE_KEY = "msal.authority_type";
    private static final String TENANT_ID_KEY = "msal.tenant_id";
    private static final String USER_ID_KEY = "msal.user_id";
    private static final String WAS_SUCCESSFUL_KEY = "msal.was_succesful";
    private static final String CORRELATION_ID_KEY = "msal.correlation_id";
    private static final String REQUEST_ID_KEY = "msal.request_id";
    private static final String IS_CONFIDENTIAL_CLIENT_KEY = "msal.is_confidential_client";
    private static final String API_ERROR_CODE_KEY = "msal.api_error_code";
    private Boolean logPii;

    public ApiEvent(Boolean bl2) {
        super("msal.api_event");
        this.logPii = bl2;
    }

    public void setApiId(int n2) {
        this.put(API_ID_KEY, Integer.toString(n2).toLowerCase(Locale.ROOT));
    }

    public void setAuthority(URI uRI) {
        this.put(AUTHORITY_KEY, ApiEvent.scrubTenant(uRI));
    }

    public void setAuthorityType(String string) {
        this.put(AUTHORITY_TYPE_KEY, string.toLowerCase(Locale.ROOT));
    }

    public void setTenantId(String string) {
        if (!StringHelper.isBlank(string) && this.logPii.booleanValue()) {
            this.put(TENANT_ID_KEY, StringHelper.createBase64EncodedSha256Hash(string));
        } else {
            this.put(TENANT_ID_KEY, null);
        }
    }

    public void setAccountId(String string) {
        if (!StringHelper.isBlank(string) && this.logPii.booleanValue()) {
            this.put(USER_ID_KEY, StringHelper.createBase64EncodedSha256Hash(string));
        } else {
            this.put(USER_ID_KEY, null);
        }
    }

    public void setWasSuccessful(boolean bl2) {
        this.put(WAS_SUCCESSFUL_KEY, String.valueOf(bl2).toLowerCase(Locale.ROOT));
    }

    public boolean getWasSuccessful() {
        return Boolean.valueOf((String)this.get(WAS_SUCCESSFUL_KEY));
    }

    public void setCorrelationId(String string) {
        this.put(CORRELATION_ID_KEY, string);
    }

    public void setRequestId(String string) {
        this.put(REQUEST_ID_KEY, string);
    }

    public void setIsConfidentialClient(boolean bl2) {
        this.put(IS_CONFIDENTIAL_CLIENT_KEY, String.valueOf(bl2).toLowerCase(Locale.ROOT));
    }

    public void setApiErrorCode(String string) {
        this.put(API_ERROR_CODE_KEY, string);
    }
}

