/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.SocketException;
import java.net.URISyntaxException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.EnvironmentVariables;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IEnvironmentVariables;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

abstract class AbstractManagedIdentitySource {
    protected static final String TIMEOUT_ERROR = "[Managed Identity] Authentication unavailable. The request to the managed identity endpoint timed out.";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractManagedIdentitySource.class);
    private static final String MANAGED_IDENTITY_NO_RESPONSE_RECEIVED = "[Managed Identity] Authentication unavailable. No response received from the managed identity endpoint.";
    protected final ManagedIdentityRequest managedIdentityRequest;
    protected final ServiceBundle serviceBundle;
    ManagedIdentitySourceType managedIdentitySourceType;
    private boolean isUserAssignedManagedIdentity;
    private String managedIdentityUserAssignedClientId;
    private String managedIdentityUserAssignedResourceId;

    public AbstractManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle, ManagedIdentitySourceType managedIdentitySourceType) {
        this.managedIdentityRequest = (ManagedIdentityRequest)msalRequest;
        this.managedIdentitySourceType = managedIdentitySourceType;
        this.serviceBundle = serviceBundle;
    }

    public ManagedIdentityResponse getManagedIdentityResponse(ManagedIdentityParameters managedIdentityParameters) {
        IHttpResponse iHttpResponse;
        this.createManagedIdentityRequest(managedIdentityParameters.resource);
        try {
            HttpRequest httpRequest = this.managedIdentityRequest.method.equals((Object)HttpMethod.GET) ? new HttpRequest(HttpMethod.GET, this.managedIdentityRequest.computeURI().toString(), this.managedIdentityRequest.headers) : new HttpRequest(HttpMethod.POST, this.managedIdentityRequest.computeURI().toString(), this.managedIdentityRequest.headers, this.managedIdentityRequest.getBodyAsString());
            iHttpResponse = this.serviceBundle.getHttpHelper().executeHttpRequest(httpRequest, this.managedIdentityRequest.requestContext(), this.serviceBundle);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        catch (MsalClientException msalClientException) {
            if (msalClientException.getCause() instanceof SocketException) {
                throw new MsalServiceException(msalClientException.getMessage(), "managed_identity_unreachable_network", this.managedIdentitySourceType);
            }
            throw msalClientException;
        }
        return this.handleResponse(managedIdentityParameters, iHttpResponse);
    }

    public ManagedIdentityResponse handleResponse(ManagedIdentityParameters managedIdentityParameters, IHttpResponse iHttpResponse) {
        try {
            if (iHttpResponse.statusCode() == 200) {
                LOG.info("[Managed Identity] Successful response received.");
                return this.getSuccessfulResponse(iHttpResponse);
            }
            String string = this.getMessageFromErrorResponse(iHttpResponse);
            LOG.error(String.format("[Managed Identity] request failed, HttpStatusCode: %s, Error message: %s", iHttpResponse.statusCode(), string));
            throw new MsalServiceException(string, "managed_identity_request_failed", this.managedIdentitySourceType);
        }
        catch (Exception exception) {
            if (exception instanceof MsalServiceException) {
                throw exception;
            }
            String string = String.format("[Managed Identity] Unexpected exception occurred when parsing the response, HttpStatusCode: %s, Error message: %s", iHttpResponse.statusCode(), exception.getMessage());
            throw new MsalServiceException(string, "managed_identity_request_failed", this.managedIdentitySourceType);
        }
    }

    public abstract void createManagedIdentityRequest(String var1);

    protected ManagedIdentityResponse getSuccessfulResponse(IHttpResponse iHttpResponse) {
        ManagedIdentityResponse managedIdentityResponse = JsonHelper.convertJsonToObject(iHttpResponse.body(), ManagedIdentityResponse.class);
        if (managedIdentityResponse == null || managedIdentityResponse.getAccessToken() == null || managedIdentityResponse.getAccessToken().isEmpty() || managedIdentityResponse.getExpiresOn() == null || managedIdentityResponse.getExpiresOn().isEmpty()) {
            throw new MsalServiceException("[Managed Identity] Response is either null or insufficient for authentication.", "managed_identity_request_failed", this.managedIdentitySourceType);
        }
        return managedIdentityResponse;
    }

    protected String getMessageFromErrorResponse(IHttpResponse iHttpResponse) {
        ManagedIdentityErrorResponse managedIdentityErrorResponse = JsonHelper.convertJsonToObject(iHttpResponse.body(), ManagedIdentityErrorResponse.class);
        if (managedIdentityErrorResponse == null) {
            return MANAGED_IDENTITY_NO_RESPONSE_RECEIVED;
        }
        if (managedIdentityErrorResponse.getMessage() != null && !managedIdentityErrorResponse.getMessage().isEmpty()) {
            return String.format("[Managed Identity] Error Message: %s Managed Identity Correlation ID: %s Use this Correlation ID for further investigation.", managedIdentityErrorResponse.getMessage(), managedIdentityErrorResponse.getCorrelationId());
        }
        return String.format("[Managed Identity] Error Code: %s Error Message: %s", managedIdentityErrorResponse.getError(), managedIdentityErrorResponse.getErrorDescription());
    }

    protected static IEnvironmentVariables getEnvironmentVariables() {
        return ManagedIdentityApplication.environmentVariables == null ? new EnvironmentVariables() : ManagedIdentityApplication.environmentVariables;
    }

    public boolean isUserAssignedManagedIdentity() {
        return this.isUserAssignedManagedIdentity;
    }

    public void setUserAssignedManagedIdentity(boolean bl2) {
        this.isUserAssignedManagedIdentity = bl2;
    }

    public String getManagedIdentityUserAssignedClientId() {
        return this.managedIdentityUserAssignedClientId;
    }

    public void setManagedIdentityUserAssignedClientId(String string) {
        this.managedIdentityUserAssignedClientId = string;
    }

    public String getManagedIdentityUserAssignedResourceId() {
        return this.managedIdentityUserAssignedResourceId;
    }

    public void setManagedIdentityUserAssignedResourceId(String string) {
        this.managedIdentityUserAssignedResourceId = string;
    }
}

