/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AADAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ADFSAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryProvider;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AccountsSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationCodeRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationRequestUrlParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.B2CAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CIAMAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DefaultHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RemoveAccountRunnable;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TelemetryManager;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenCache;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserIdentifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;

public abstract class AbstractClientApplicationBase
extends AbstractApplicationBase
implements IClientApplicationBase {
    private String clientId;
    private String authority;
    private boolean validateAuthority;
    private String applicationName;
    private String applicationVersion;
    private AadInstanceDiscoveryResponse aadAadInstanceDiscoveryResponse;
    private String clientCapabilities;
    private boolean autoDetectRegion;
    protected String azureRegion;
    private boolean instanceDiscovery;

    protected abstract ClientAuthentication clientAuthentication();

    @Override
    public TokenCache tokenCache() {
        return this.tokenCache;
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(AuthorizationCodeParameters authorizationCodeParameters) {
        ParameterValidationUtils.validateNotNull("parameters", authorizationCodeParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_AUTHORIZATION_CODE, authorizationCodeParameters);
        AuthorizationCodeRequest authorizationCodeRequest = new AuthorizationCodeRequest(authorizationCodeParameters, this, requestContext);
        return this.executeRequest(authorizationCodeRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken(RefreshTokenParameters refreshTokenParameters) {
        ParameterValidationUtils.validateNotNull("parameters", refreshTokenParameters);
        RequestContext requestContext = new RequestContext(this, PublicApi.ACQUIRE_TOKEN_BY_REFRESH_TOKEN, refreshTokenParameters);
        RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(refreshTokenParameters, (AbstractApplicationBase)this, requestContext);
        return this.executeRequest(refreshTokenRequest);
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireTokenSilently(SilentParameters silentParameters) throws MalformedURLException {
        ParameterValidationUtils.validateNotNull("parameters", silentParameters);
        RequestContext requestContext = silentParameters.account() != null ? new RequestContext(this, PublicApi.ACQUIRE_TOKEN_SILENTLY, silentParameters, UserIdentifier.fromHomeAccountId(silentParameters.account().homeAccountId())) : new RequestContext(this, PublicApi.ACQUIRE_TOKEN_SILENTLY, silentParameters);
        SilentRequest silentRequest = new SilentRequest(silentParameters, this, requestContext, null);
        return this.executeRequest(silentRequest);
    }

    @Override
    public CompletableFuture<Set<IAccount>> getAccounts() {
        RequestContext requestContext = new RequestContext(this, PublicApi.GET_ACCOUNTS, null);
        MsalRequest msalRequest = new MsalRequest(this, null, requestContext){};
        AccountsSupplier accountsSupplier = new AccountsSupplier(this, msalRequest);
        return super.serviceBundle().getExecutorService() != null ? CompletableFuture.supplyAsync(accountsSupplier, super.serviceBundle().getExecutorService()) : CompletableFuture.supplyAsync(accountsSupplier);
    }

    @Override
    public CompletableFuture<Void> removeAccount(IAccount iAccount) {
        RequestContext requestContext = new RequestContext(this, PublicApi.REMOVE_ACCOUNTS, null);
        MsalRequest msalRequest = new MsalRequest(this, null, requestContext){};
        RemoveAccountRunnable removeAccountRunnable = new RemoveAccountRunnable(msalRequest, iAccount);
        return super.serviceBundle().getExecutorService() != null ? CompletableFuture.runAsync(removeAccountRunnable, super.serviceBundle().getExecutorService()) : CompletableFuture.runAsync(removeAccountRunnable);
    }

    @Override
    public URL getAuthorizationRequestUrl(AuthorizationRequestUrlParameters authorizationRequestUrlParameters) {
        ParameterValidationUtils.validateNotNull("parameters", authorizationRequestUrlParameters);
        authorizationRequestUrlParameters.requestParameters.put("client_id", Collections.singletonList(this.clientId));
        if (this.clientCapabilities != null) {
            if (authorizationRequestUrlParameters.requestParameters.containsKey("claims")) {
                String string = String.valueOf(authorizationRequestUrlParameters.requestParameters.get("claims").get(0));
                String string2 = JsonHelper.mergeJSONString(string, this.clientCapabilities);
                authorizationRequestUrlParameters.requestParameters.put("claims", Collections.singletonList(string2));
            } else {
                authorizationRequestUrlParameters.requestParameters.put("claims", Collections.singletonList(this.clientCapabilities));
            }
        }
        return authorizationRequestUrlParameters.createAuthorizationURL(this.authenticationAuthority, authorizationRequestUrlParameters.requestParameters());
    }

    AbstractClientApplicationBase(Builder<?> builder) {
        super(builder);
        this.clientId = ((Builder)builder).clientId;
        this.authority = ((Builder)builder).authority;
        this.validateAuthority = ((Builder)builder).validateAuthority;
        this.applicationName = ((Builder)builder).applicationName;
        this.applicationVersion = ((Builder)builder).applicationVersion;
        this.authenticationAuthority = ((Builder)builder).authenticationAuthority;
        this.tokenCache = new TokenCache(((Builder)builder).tokenCacheAccessAspect);
        this.aadAadInstanceDiscoveryResponse = ((Builder)builder).aadInstanceDiscoveryResponse;
        this.clientCapabilities = ((Builder)builder).clientCapabilities;
        this.autoDetectRegion = ((Builder)builder).autoDetectRegion;
        this.azureRegion = ((Builder)builder).azureRegion;
        this.instanceDiscovery = builder.isInstanceDiscoveryEnabled;
        this.serviceBundle = new ServiceBundle(builder.executorService, new TelemetryManager(this.telemetryConsumer, builder.onlySendFailureTelemetry), new HttpHelper(builder.httpClient == null ? new DefaultHttpClient(builder.proxy, builder.sslSocketFactory, builder.connectTimeoutForDefaultHttpClient, builder.readTimeoutForDefaultHttpClient) : builder.httpClient));
        if (this.aadAadInstanceDiscoveryResponse != null) {
            AadInstanceDiscoveryProvider.cacheInstanceDiscoveryResponse(this.authenticationAuthority.host, this.aadAadInstanceDiscoveryResponse);
        }
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public boolean validateAuthority() {
        return this.validateAuthority;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationVersion() {
        return this.applicationVersion;
    }

    public AadInstanceDiscoveryResponse aadAadInstanceDiscoveryResponse() {
        return this.aadAadInstanceDiscoveryResponse;
    }

    public String clientCapabilities() {
        return this.clientCapabilities;
    }

    public boolean autoDetectRegion() {
        return this.autoDetectRegion;
    }

    public String azureRegion() {
        return this.azureRegion;
    }

    public boolean instanceDiscovery() {
        return this.instanceDiscovery;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractApplicationBase.Builder<T> {
        private String clientId;
        private String authority = "https://login.microsoftonline.com/common/";
        private Authority authenticationAuthority = Builder.createDefaultAADAuthority();
        private boolean validateAuthority = true;
        private String applicationName;
        private String applicationVersion;
        private ITokenCacheAccessAspect tokenCacheAccessAspect;
        private AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse;
        private String clientCapabilities;
        private boolean autoDetectRegion;
        private String azureRegion;
        protected boolean isInstanceDiscoveryEnabled = true;

        public Builder(String string) {
            ParameterValidationUtils.validateNotBlank("clientId", string);
            this.clientId = string;
        }

        @Override
        abstract T self();

        public T authority(String string) throws MalformedURLException {
            this.authority = Authority.enforceTrailingSlash(string);
            URL uRL = new URL(this.authority);
            switch (Authority.detectAuthorityType(uRL)) {
                case AAD: {
                    this.authenticationAuthority = new AADAuthority(uRL);
                    break;
                }
                case ADFS: {
                    this.authenticationAuthority = new ADFSAuthority(uRL);
                    break;
                }
                case CIAM: {
                    this.authenticationAuthority = new CIAMAuthority(uRL);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported authority type.");
                }
            }
            Authority.validateAuthority(this.authenticationAuthority.canonicalAuthorityUrl());
            return (T)this.self();
        }

        public T b2cAuthority(String string) throws MalformedURLException {
            this.authority = Authority.enforceTrailingSlash(string);
            URL uRL = new URL(this.authority);
            Authority.validateAuthority(uRL);
            if (Authority.detectAuthorityType(uRL) != AuthorityType.B2C) {
                throw new IllegalArgumentException("Unsupported authority type. Please use B2C authority");
            }
            this.authenticationAuthority = new B2CAuthority(uRL);
            this.validateAuthority = false;
            return (T)this.self();
        }

        public T validateAuthority(boolean bl2) {
            this.validateAuthority = bl2;
            return (T)this.self();
        }

        public T applicationName(String string) {
            ParameterValidationUtils.validateNotNull("applicationName", string);
            this.applicationName = string;
            return (T)this.self();
        }

        public T applicationVersion(String string) {
            ParameterValidationUtils.validateNotNull("applicationVersion", string);
            this.applicationVersion = string;
            return (T)this.self();
        }

        public T setTokenCacheAccessAspect(ITokenCacheAccessAspect iTokenCacheAccessAspect) {
            ParameterValidationUtils.validateNotNull("tokenCacheAccessAspect", iTokenCacheAccessAspect);
            this.tokenCacheAccessAspect = iTokenCacheAccessAspect;
            return (T)this.self();
        }

        public T aadInstanceDiscoveryResponse(String string) {
            ParameterValidationUtils.validateNotNull("aadInstanceDiscoveryResponse", string);
            this.aadInstanceDiscoveryResponse = AadInstanceDiscoveryProvider.parseInstanceDiscoveryMetadata(string);
            return (T)this.self();
        }

        private static Authority createDefaultAADAuthority() {
            AADAuthority aADAuthority;
            try {
                aADAuthority = new AADAuthority(new URL("https://login.microsoftonline.com/common/"));
            }
            catch (Exception exception) {
                throw new MsalClientException(exception);
            }
            return aADAuthority;
        }

        public T clientCapabilities(Set<String> set) {
            this.clientCapabilities = JsonHelper.formCapabilitiesJson(set);
            return (T)this.self();
        }

        public T autoDetectRegion(boolean bl2) {
            this.autoDetectRegion = bl2;
            return (T)this.self();
        }

        public T azureRegion(String string) {
            this.azureRegion = string;
            return (T)this.self();
        }

        public T instanceDiscovery(boolean bl2) {
            this.isInstanceDiscoveryEnabled = bl2;
            return (T)this.self();
        }

        @Override
        abstract AbstractClientApplicationBase build();
    }
}

