/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AADAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryProvider;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByClientCredentialSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByDeviceCodeFlowSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByInteractiveFlowSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByManagedIdentitySupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByOnBehalfOfSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.LogHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OnBehalfOfRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenCache;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenRequestExecutor;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;

public abstract class AbstractApplicationBase
implements IApplicationBase {
    protected Logger log;
    protected Authority authenticationAuthority;
    private String correlationId;
    private boolean logPii;
    private Proxy proxy;
    private SSLSocketFactory sslSocketFactory;
    private IHttpClient httpClient;
    private Integer connectTimeoutForDefaultHttpClient;
    private Integer readTimeoutForDefaultHttpClient;
    String tenant;
    private boolean validateAuthority;
    private String clientId;
    private String authority;
    ServiceBundle serviceBundle;
    Consumer<List<HashMap<String, String>>> telemetryConsumer;
    protected TokenCache tokenCache;

    CompletableFuture<IAuthenticationResult> executeRequest(MsalRequest msalRequest) {
        AuthenticationResultSupplier authenticationResultSupplier = this.getAuthenticationResultSupplier(msalRequest);
        ExecutorService executorService = this.serviceBundle.getExecutorService();
        return executorService != null ? CompletableFuture.supplyAsync(authenticationResultSupplier, executorService) : CompletableFuture.supplyAsync(authenticationResultSupplier);
    }

    AuthenticationResult acquireTokenCommon(MsalRequest msalRequest, Authority authority) throws Exception {
        HttpHeaders httpHeaders = msalRequest.headers();
        if (this.logPii) {
            this.log.debug(LogHelper.createMessage(String.format("Using Client Http Headers: %s", httpHeaders), httpHeaders.getHeaderCorrelationIdValue()));
        }
        TokenRequestExecutor tokenRequestExecutor = new TokenRequestExecutor(authority, msalRequest, this.serviceBundle);
        AuthenticationResult authenticationResult = tokenRequestExecutor.executeTokenRequest();
        if (this.authenticationAuthority.authorityType.equals((Object)AuthorityType.AAD)) {
            InstanceDiscoveryMetadataEntry instanceDiscoveryMetadataEntry = AadInstanceDiscoveryProvider.getMetadataEntry(authority.canonicalAuthorityUrl(), this.validateAuthority, msalRequest, this.serviceBundle);
            this.tokenCache.saveTokens(tokenRequestExecutor, authenticationResult, instanceDiscoveryMetadataEntry.preferredCache);
        } else {
            this.tokenCache.saveTokens(tokenRequestExecutor, authenticationResult, this.authenticationAuthority.host);
        }
        return authenticationResult;
    }

    private AuthenticationResultSupplier getAuthenticationResultSupplier(MsalRequest msalRequest) {
        AuthenticationResultSupplier authenticationResultSupplier = msalRequest instanceof DeviceCodeFlowRequest ? new AcquireTokenByDeviceCodeFlowSupplier((PublicClientApplication)this, (DeviceCodeFlowRequest)msalRequest) : (msalRequest instanceof SilentRequest ? new AcquireTokenSilentSupplier(this, (SilentRequest)msalRequest) : (msalRequest instanceof InteractiveRequest ? new AcquireTokenByInteractiveFlowSupplier((PublicClientApplication)this, (InteractiveRequest)msalRequest) : (msalRequest instanceof ClientCredentialRequest ? new AcquireTokenByClientCredentialSupplier((ConfidentialClientApplication)this, (ClientCredentialRequest)msalRequest) : (msalRequest instanceof OnBehalfOfRequest ? new AcquireTokenByOnBehalfOfSupplier((ConfidentialClientApplication)this, (OnBehalfOfRequest)msalRequest) : (msalRequest instanceof ManagedIdentityRequest ? new AcquireTokenByManagedIdentitySupplier((ManagedIdentityApplication)this, (MsalRequest)((ManagedIdentityRequest)msalRequest)) : new AcquireTokenByAuthorizationGrantSupplier(this, msalRequest, null))))));
        return authenticationResultSupplier;
    }

    AbstractApplicationBase(Builder<?> builder) {
        this.correlationId = ((Builder)builder).correlationId;
        this.logPii = ((Builder)builder).logPii;
        this.telemetryConsumer = ((Builder)builder).telemetryConsumer;
        this.proxy = builder.proxy;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.connectTimeoutForDefaultHttpClient = builder.connectTimeoutForDefaultHttpClient;
        this.readTimeoutForDefaultHttpClient = builder.readTimeoutForDefaultHttpClient;
        this.authenticationAuthority = ((Builder)builder).authenticationAuthority;
        this.clientId = ((Builder)builder).clientId;
    }

    @Override
    public String correlationId() {
        return this.correlationId;
    }

    @Override
    public boolean logPii() {
        return this.logPii;
    }

    @Override
    public Proxy proxy() {
        return this.proxy;
    }

    @Override
    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public IHttpClient httpClient() {
        return this.httpClient;
    }

    public Integer connectTimeoutForDefaultHttpClient() {
        return this.connectTimeoutForDefaultHttpClient;
    }

    public Integer readTimeoutForDefaultHttpClient() {
        return this.readTimeoutForDefaultHttpClient;
    }

    String tenant() {
        return this.tenant;
    }

    boolean validateAuthority() {
        return this.validateAuthority;
    }

    String clientId() {
        return this.clientId;
    }

    String authority() {
        return this.authority;
    }

    ServiceBundle serviceBundle() {
        return this.serviceBundle;
    }

    Consumer<List<HashMap<String, String>>> telemetryConsumer() {
        return this.telemetryConsumer;
    }

    TokenCache tokenCache() {
        return this.tokenCache;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String correlationId;
        private boolean logPii = false;
        ExecutorService executorService;
        Proxy proxy;
        SSLSocketFactory sslSocketFactory;
        IHttpClient httpClient;
        private Consumer<List<HashMap<String, String>>> telemetryConsumer;
        Boolean onlySendFailureTelemetry = false;
        Integer connectTimeoutForDefaultHttpClient;
        Integer readTimeoutForDefaultHttpClient;
        private String clientId;
        private Authority authenticationAuthority = Builder.createDefaultAADAuthority();

        public Builder() {
        }

        public Builder(String string) {
            ParameterValidationUtils.validateNotBlank("clientId", string);
            this.clientId = string;
        }

        abstract T self();

        public T correlationId(String string) {
            ParameterValidationUtils.validateNotBlank("correlationId", string);
            this.correlationId = string;
            return this.self();
        }

        public T logPii(boolean bl2) {
            this.logPii = bl2;
            return this.self();
        }

        public T executorService(ExecutorService executorService) {
            ParameterValidationUtils.validateNotNull("executorService", executorService);
            this.executorService = executorService;
            return this.self();
        }

        public T proxy(Proxy proxy) {
            ParameterValidationUtils.validateNotNull("proxy", proxy);
            this.proxy = proxy;
            return this.self();
        }

        public T httpClient(IHttpClient iHttpClient) {
            ParameterValidationUtils.validateNotNull("httpClient", iHttpClient);
            this.httpClient = iHttpClient;
            return this.self();
        }

        public T sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            ParameterValidationUtils.validateNotNull("sslSocketFactory", sSLSocketFactory);
            this.sslSocketFactory = sSLSocketFactory;
            return this.self();
        }

        public T connectTimeoutForDefaultHttpClient(Integer n2) {
            ParameterValidationUtils.validateNotNull("connectTimeoutForDefaultHttpClient", n2);
            this.connectTimeoutForDefaultHttpClient = n2;
            return this.self();
        }

        public T readTimeoutForDefaultHttpClient(Integer n2) {
            ParameterValidationUtils.validateNotNull("readTimeoutForDefaultHttpClient", n2);
            this.readTimeoutForDefaultHttpClient = n2;
            return this.self();
        }

        T telemetryConsumer(Consumer<List<HashMap<String, String>>> consumer) {
            ParameterValidationUtils.validateNotNull("telemetryConsumer", consumer);
            this.telemetryConsumer = consumer;
            return this.self();
        }

        T onlySendFailureTelemetry(Boolean bl2) {
            this.onlySendFailureTelemetry = bl2;
            return this.self();
        }

        private static Authority createDefaultAADAuthority() {
            AADAuthority aADAuthority;
            try {
                aADAuthority = new AADAuthority(new URL("https://login.microsoftonline.com/common/"));
            }
            catch (Exception exception) {
                throw new MsalClientException(exception);
            }
            return aADAuthority;
        }

        abstract AbstractApplicationBase build();
    }
}

