/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AadInstanceDiscoveryResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CurrentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceExceptionFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RegionTelemetry;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AadInstanceDiscoveryProvider {
    private static final String DEFAULT_TRUSTED_HOST = "login.microsoftonline.com";
    private static final String AUTHORIZE_ENDPOINT_TEMPLATE = "https://{host}/{tenant}/oauth2/v2.0/authorize";
    private static final String INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE = "https://{host}:{port}/common/discovery/instance";
    private static final String INSTANCE_DISCOVERY_REQUEST_PARAMETERS_TEMPLATE = "?api-version=1.1&authorization_endpoint={authorizeEndpoint}";
    private static final String HOST_TEMPLATE_WITH_REGION = "{region}.login.microsoft.com";
    private static final String SOVEREIGN_HOST_TEMPLATE_WITH_REGION = "{region}.{host}";
    private static final String REGION_NAME = "REGION_NAME";
    private static final int PORT_NOT_SET = -1;
    private static final String DEFAULT_API_VERSION = "2020-06-01";
    private static final String IMDS_ENDPOINT = "http://169.254.169.254/metadata/instance/compute/location?api-version=2020-06-01&format=text";
    private static final int IMDS_TIMEOUT = 2;
    private static final TimeUnit IMDS_TIMEOUT_UNIT = TimeUnit.SECONDS;
    static final TreeSet<String> TRUSTED_HOSTS_SET = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    static final TreeSet<String> TRUSTED_SOVEREIGN_HOSTS_SET = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private static final Logger log = LoggerFactory.getLogger(AadInstanceDiscoveryProvider.class);
    private static boolean instanceDiscoveryFailed = false;
    static ConcurrentHashMap<String, InstanceDiscoveryMetadataEntry> cache = new ConcurrentHashMap();

    AadInstanceDiscoveryProvider() {
    }

    static InstanceDiscoveryMetadataEntry getMetadataEntry(URL uRL, boolean bl2, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        String string = uRL.getHost();
        if (msalRequest.application() instanceof ManagedIdentityApplication || !((AbstractClientApplicationBase)msalRequest.application()).instanceDiscovery()) {
            if (cache.get(string) == null) {
                log.debug("Instance discovery set to false, caching a default entry.");
                AadInstanceDiscoveryProvider.cacheInstanceDiscoveryMetadata(string);
            }
            return cache.get(string);
        }
        if (AadInstanceDiscoveryProvider.shouldUseRegionalEndpoint(msalRequest) && ((AbstractClientApplicationBase)msalRequest.application()).azureRegion() != null) {
            string = AadInstanceDiscoveryProvider.getRegionalizedHost(uRL.getHost(), ((AbstractClientApplicationBase)msalRequest.application()).azureRegion());
        }
        if (cache.get(string) == null) {
            log.debug("No cached instance metadata, will attempt instance discovery.");
            if (AadInstanceDiscoveryProvider.shouldUseRegionalEndpoint(msalRequest)) {
                log.debug("Region API used, will attempt to discover Azure region.");
                String string2 = AadInstanceDiscoveryProvider.discoverRegion(msalRequest, serviceBundle);
                if (((AbstractClientApplicationBase)msalRequest.application()).azureRegion() == null && ((AbstractClientApplicationBase)msalRequest.application()).autoDetectRegion() && string2 != null) {
                    log.debug(String.format("Region autodetection found %s, this region will be used for future calls.", string2));
                    ((AbstractClientApplicationBase)msalRequest.application()).azureRegion = string2;
                    string = AadInstanceDiscoveryProvider.getRegionalizedHost(uRL.getHost(), ((AbstractClientApplicationBase)msalRequest.application()).azureRegion());
                }
                AadInstanceDiscoveryProvider.cacheRegionInstanceMetadata(uRL.getHost(), string);
                serviceBundle.getServerSideTelemetry().getCurrentRequest().regionOutcome(AadInstanceDiscoveryProvider.determineRegionOutcome(string2, ((AbstractClientApplicationBase)msalRequest.application()).azureRegion(), ((AbstractClientApplicationBase)msalRequest.application()).autoDetectRegion()));
            }
            AadInstanceDiscoveryProvider.doInstanceDiscoveryAndCache(uRL, bl2, msalRequest, serviceBundle);
        }
        return cache.get(string);
    }

    static Set<String> getAliases(String string) {
        if (cache.containsKey(string)) {
            return cache.get(string).aliases();
        }
        return Collections.singleton(string);
    }

    static AadInstanceDiscoveryResponse parseInstanceDiscoveryMetadata(String string) {
        AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse;
        try {
            aadInstanceDiscoveryResponse = JsonHelper.convertJsonToObject(string, AadInstanceDiscoveryResponse.class);
        }
        catch (Exception exception) {
            throw new MsalClientException("Error parsing instance discovery response. Data must be in valid JSON format. For more information, see https://aka.ms/msal4j-instance-discovery", "invalid_instance_discovery_metadata");
        }
        return aadInstanceDiscoveryResponse;
    }

    static void cacheInstanceDiscoveryResponse(String string, AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse) {
        if (aadInstanceDiscoveryResponse != null && aadInstanceDiscoveryResponse.metadata() != null) {
            for (InstanceDiscoveryMetadataEntry instanceDiscoveryMetadataEntry : aadInstanceDiscoveryResponse.metadata()) {
                for (String string2 : instanceDiscoveryMetadataEntry.aliases()) {
                    cache.put(string2, instanceDiscoveryMetadataEntry);
                }
            }
        }
        AadInstanceDiscoveryProvider.cacheInstanceDiscoveryMetadata(string);
    }

    static void cacheInstanceDiscoveryMetadata(String string) {
        cache.putIfAbsent(string, InstanceDiscoveryMetadataEntry.builder().preferredCache(string).preferredNetwork(string).aliases(Collections.singleton(string)).build());
    }

    private static boolean shouldUseRegionalEndpoint(MsalRequest msalRequest) {
        if (((AbstractClientApplicationBase)msalRequest.application()).azureRegion() != null || ((AbstractClientApplicationBase)msalRequest.application()).autoDetectRegion()) {
            if (msalRequest.getClass() == ClientCredentialRequest.class) {
                return true;
            }
            if (msalRequest.getClass() != SilentRequest.class) {
                log.warn("Regional endpoints are only available for client credential flow, request will fall back to using the global endpoint. See here for more information about supported scenarios: https://aka.ms/msal4j-azure-regions");
            }
            return false;
        }
        return false;
    }

    static void cacheRegionInstanceMetadata(String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        cache.putIfAbsent(string2, InstanceDiscoveryMetadataEntry.builder().preferredCache(string).preferredNetwork(string2).aliases(hashSet).build());
    }

    private static String getRegionalizedHost(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string.contains(string2)) {
            return string;
        }
        String string3 = TRUSTED_HOSTS_SET.contains(string) && !TRUSTED_SOVEREIGN_HOSTS_SET.contains(string) ? HOST_TEMPLATE_WITH_REGION.replace("{region}", string2) : SOVEREIGN_HOST_TEMPLATE_WITH_REGION.replace("{region}", string2).replace("{host}", string);
        return string3;
    }

    private static String getAuthorizeEndpoint(String string, String string2) {
        return AUTHORIZE_ENDPOINT_TEMPLATE.replace("{host}", string).replace("{tenant}", string2);
    }

    private static String getInstanceDiscoveryEndpoint(URL uRL) {
        String string = TRUSTED_HOSTS_SET.contains(uRL.getHost()) ? uRL.getHost() : DEFAULT_TRUSTED_HOST;
        int n2 = uRL.getPort() == -1 ? uRL.getDefaultPort() : uRL.getPort();
        return INSTANCE_DISCOVERY_ENDPOINT_TEMPLATE.replace("{host}", string).replace("{port}", String.valueOf(n2));
    }

    static AadInstanceDiscoveryResponse sendInstanceDiscoveryRequest(URL uRL, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        String string = AadInstanceDiscoveryProvider.getInstanceDiscoveryEndpoint(uRL) + AadInstanceDiscoveryProvider.formInstanceDiscoveryParameters(uRL);
        IHttpResponse iHttpResponse = AadInstanceDiscoveryProvider.executeRequest(string, msalRequest.headers().getReadonlyHeaderMap(), msalRequest, serviceBundle);
        AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse = JsonHelper.convertJsonToObject(iHttpResponse.body(), AadInstanceDiscoveryResponse.class);
        if (iHttpResponse.statusCode() != 200) {
            if (iHttpResponse.statusCode() == 400 && aadInstanceDiscoveryResponse.error().equals("invalid_instance")) {
                throw MsalServiceExceptionFactory.fromHttpResponse(iHttpResponse);
            }
            log.debug("Instance discovery failed due to an unknown error, no more instance discovery attempts will be made.");
            AadInstanceDiscoveryProvider.cacheInstanceDiscoveryMetadata(uRL.getHost());
        }
        return aadInstanceDiscoveryResponse;
    }

    private static int determineRegionOutcome(String string, String string2, boolean bl2) {
        int n2 = 0;
        if (string2 != null) {
            n2 = string == null ? RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_FAILED.telemetryValue : (string2.equals(string) ? RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_MATCH.telemetryValue : RegionTelemetry.REGION_OUTCOME_DEVELOPER_AUTODETECT_MISMATCH.telemetryValue);
        } else if (bl2) {
            n2 = string == null ? RegionTelemetry.REGION_OUTCOME_AUTODETECT_FAILED.telemetryValue : RegionTelemetry.REGION_OUTCOME_AUTODETECT_SUCCESS.telemetryValue;
        }
        return n2;
    }

    private static String formInstanceDiscoveryParameters(URL uRL) {
        return INSTANCE_DISCOVERY_REQUEST_PARAMETERS_TEMPLATE.replace("{authorizeEndpoint}", AadInstanceDiscoveryProvider.getAuthorizeEndpoint(uRL.getHost(), Authority.getTenant(uRL, Authority.detectAuthorityType(uRL))));
    }

    private static IHttpResponse executeRequest(String string, Map<String, String> map, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string, map);
        return serviceBundle.getHttpHelper().executeHttpRequest(httpRequest, msalRequest.requestContext(), serviceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String discoverRegion(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        CurrentRequest currentRequest = serviceBundle.getServerSideTelemetry().getCurrentRequest();
        if (System.getenv(REGION_NAME) != null) {
            log.info(String.format("Region found in environment variable: %s", System.getenv(REGION_NAME)));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_ENV_VARIABLE.telemetryValue);
            return System.getenv(REGION_NAME);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Metadata", "true");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<IHttpResponse> future = executorService.submit(() -> AadInstanceDiscoveryProvider.executeRequest(IMDS_ENDPOINT, hashMap, msalRequest, serviceBundle));
        try {
            log.info("Starting call to IMDS endpoint.");
            IHttpResponse iHttpResponse = future.get(2L, IMDS_TIMEOUT_UNIT);
            if (iHttpResponse.statusCode() == 200 && !iHttpResponse.body().isEmpty()) {
                log.info(String.format("Region retrieved from IMDS endpoint: %s", iHttpResponse.body()));
                currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_IMDS.telemetryValue);
                String string = iHttpResponse.body();
                return string;
            }
            log.warn(String.format("Call to local IMDS failed with status code: %s, or response was empty", iHttpResponse.statusCode()));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_FAILED_AUTODETECT.telemetryValue);
        }
        catch (Exception exception) {
            log.warn(String.format("Exception during call to local IMDS endpoint: %s", exception.getMessage()));
            currentRequest.regionSource(RegionTelemetry.REGION_SOURCE_FAILED_AUTODETECT.telemetryValue);
            future.cancel(true);
        }
        finally {
            executorService.shutdownNow();
        }
        return null;
    }

    private static void doInstanceDiscoveryAndCache(URL uRL, boolean bl2, MsalRequest msalRequest, ServiceBundle serviceBundle) {
        AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse = null;
        if (msalRequest.application().authenticationAuthority.authorityType.equals((Object)AuthorityType.AAD)) {
            aadInstanceDiscoveryResponse = AadInstanceDiscoveryProvider.sendInstanceDiscoveryRequest(uRL, msalRequest, serviceBundle);
            if (bl2) {
                AadInstanceDiscoveryProvider.validate(aadInstanceDiscoveryResponse);
            }
        }
        AadInstanceDiscoveryProvider.cacheInstanceDiscoveryResponse(uRL.getHost(), aadInstanceDiscoveryResponse);
    }

    private static void validate(AadInstanceDiscoveryResponse aadInstanceDiscoveryResponse) {
        if (StringHelper.isBlank(aadInstanceDiscoveryResponse.tenantDiscoveryEndpoint())) {
            throw new MsalServiceException(aadInstanceDiscoveryResponse);
        }
    }

    static {
        TRUSTED_SOVEREIGN_HOSTS_SET.addAll(Arrays.asList("login.chinacloudapi.cn", "login-us.microsoftonline.com", "login.microsoftonline.de", "login.microsoftonline.us"));
        TRUSTED_HOSTS_SET.addAll(Arrays.asList("login.windows.net", DEFAULT_TRUSTED_HOST, "login.microsoft.com", "sts.windows.net"));
        TRUSTED_HOSTS_SET.addAll(TRUSTED_SOVEREIGN_HOSTS_SET);
    }
}

