/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.google.gson.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonElement;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonIOException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonNull;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonParseException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.bind.TypeAdapters;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.MalformedJsonException;

public final class Streams {
    private Streams() {
        throw new UnsupportedOperationException();
    }

    public static JsonElement parse(JsonReader jsonReader) throws JsonParseException {
        boolean bl2 = true;
        try {
            jsonReader.peek();
            bl2 = false;
            return TypeAdapters.JSON_ELEMENT.read(jsonReader);
        }
        catch (EOFException eOFException) {
            if (bl2) {
                return JsonNull.INSTANCE;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonSyntaxException(numberFormatException);
        }
    }

    public static void write(JsonElement jsonElement, JsonWriter jsonWriter) throws IOException {
        TypeAdapters.JSON_ELEMENT.write(jsonWriter, jsonElement);
    }

    public static Writer writerForAppendable(Appendable appendable) {
        return appendable instanceof Writer ? (Writer)appendable : new AppendableWriter(appendable);
    }

    private static final class AppendableWriter
    extends Writer {
        private final Appendable appendable;
        private final CurrentWrite currentWrite = new CurrentWrite();

        AppendableWriter(Appendable appendable) {
            this.appendable = appendable;
        }

        @Override
        public void write(char[] cArray, int n2, int n3) throws IOException {
            this.currentWrite.setChars(cArray);
            this.appendable.append(this.currentWrite, n2, n2 + n3);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(int n2) throws IOException {
            this.appendable.append((char)n2);
        }

        @Override
        public void write(String string, int n2, int n3) throws IOException {
            Objects.requireNonNull(string);
            this.appendable.append(string, n2, n2 + n3);
        }

        @Override
        public Writer append(CharSequence charSequence) throws IOException {
            this.appendable.append(charSequence);
            return this;
        }

        @Override
        public Writer append(CharSequence charSequence, int n2, int n3) throws IOException {
            this.appendable.append(charSequence, n2, n3);
            return this;
        }

        private static class CurrentWrite
        implements CharSequence {
            private char[] chars;
            private String cachedString;

            private CurrentWrite() {
            }

            void setChars(char[] cArray) {
                this.chars = cArray;
                this.cachedString = null;
            }

            @Override
            public int length() {
                return this.chars.length;
            }

            @Override
            public char charAt(int n2) {
                return this.chars[n2];
            }

            @Override
            public CharSequence subSequence(int n2, int n3) {
                return new String(this.chars, n2, n3 - n2);
            }

            @Override
            public String toString() {
                if (this.cachedString == null) {
                    this.cachedString = new String(this.chars);
                }
                return this.cachedString;
            }
        }
    }
}

