/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.VersionUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionAction;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;

public class JSR310StringParsableDeserializer
extends JSR310DeserializerBase<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final int TYPE_PERIOD = 1;
    protected static final int TYPE_ZONE_ID = 2;
    protected static final int TYPE_ZONE_OFFSET = 3;
    public static final JsonDeserializer<Period> PERIOD = JSR310StringParsableDeserializer.createDeserializer(Period.class, 1);
    public static final JsonDeserializer<ZoneId> ZONE_ID = JSR310StringParsableDeserializer.createDeserializer(ZoneId.class, 2);
    public static final JsonDeserializer<ZoneOffset> ZONE_OFFSET = JSR310StringParsableDeserializer.createDeserializer(ZoneOffset.class, 3);
    protected final int _typeSelector;

    protected JSR310StringParsableDeserializer(Class<?> clazz, int n2) {
        super(clazz);
        this._typeSelector = n2;
    }

    protected JSR310StringParsableDeserializer(JSR310StringParsableDeserializer jSR310StringParsableDeserializer, Boolean bl2) {
        super(jSR310StringParsableDeserializer, bl2);
        this._typeSelector = jSR310StringParsableDeserializer._typeSelector;
    }

    protected static <T> JsonDeserializer<T> createDeserializer(Class<T> clazz, int n2) {
        return new JSR310StringParsableDeserializer(clazz, n2);
    }

    protected JSR310StringParsableDeserializer withLeniency(Boolean bl2) {
        if (this._isLenient == !Boolean.FALSE.equals(bl2)) {
            return this;
        }
        return new JSR310StringParsableDeserializer(this, bl2);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        Boolean bl2;
        JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, this.handledType());
        JSR310StringParsableDeserializer jSR310StringParsableDeserializer = this;
        if (value != null && value.hasLenient() && (bl2 = value.getLenient()) != null) {
            jSR310StringParsableDeserializer = this.withLeniency(bl2);
        }
        return jSR310StringParsableDeserializer;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return jsonParser.getEmbeddedObject();
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            return this._deserializeFromArray(jsonParser, deserializationContext);
        }
        throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.VALUE_STRING, null);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken != null && jsonToken.isScalarValue()) {
            return this.deserialize(jsonParser, deserializationContext);
        }
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected Object _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        if ((string = string.trim()).length() == 0) {
            CoercionAction coercionAction = deserializationContext.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.EmptyString);
            if (coercionAction == CoercionAction.Fail) {
                deserializationContext.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
            }
            if (!this.isLenient()) {
                return this._failForNotLenient(jsonParser, deserializationContext, JsonToken.VALUE_STRING);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return this.getEmptyValue(deserializationContext);
            }
            return null;
        }
        try {
            switch (this._typeSelector) {
                case 1: {
                    return Period.parse(string);
                }
                case 2: {
                    return ZoneId.of(string);
                }
                case 3: {
                    return ZoneOffset.of(string);
                }
            }
        }
        catch (DateTimeException dateTimeException) {
            return this._handleDateTimeException(deserializationContext, dateTimeException, string);
        }
        VersionUtil.throwInternal();
        return null;
    }
}

