/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.MapperFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;

public abstract class JSR310DateTimeDeserializerBase<T>
extends JSR310DeserializerBase<T>
implements ContextualDeserializer {
    protected final DateTimeFormatter _formatter;
    protected final JsonFormat.Shape _shape;

    protected JSR310DateTimeDeserializerBase(Class<T> clazz, DateTimeFormatter dateTimeFormatter) {
        super(clazz);
        this._formatter = dateTimeFormatter;
        this._shape = null;
    }

    public JSR310DateTimeDeserializerBase(Class<T> clazz, DateTimeFormatter dateTimeFormatter, Boolean bl2) {
        super(clazz, bl2);
        this._formatter = dateTimeFormatter;
        this._shape = null;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> jSR310DateTimeDeserializerBase, DateTimeFormatter dateTimeFormatter) {
        super(jSR310DateTimeDeserializerBase);
        this._formatter = dateTimeFormatter;
        this._shape = jSR310DateTimeDeserializerBase._shape;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> jSR310DateTimeDeserializerBase, Boolean bl2) {
        super(jSR310DateTimeDeserializerBase, bl2);
        this._formatter = jSR310DateTimeDeserializerBase._formatter;
        this._shape = jSR310DateTimeDeserializerBase._shape;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> jSR310DateTimeDeserializerBase, JsonFormat.Shape shape) {
        super(jSR310DateTimeDeserializerBase);
        this._formatter = jSR310DateTimeDeserializerBase._formatter;
        this._shape = shape;
    }

    protected JSR310DateTimeDeserializerBase(JSR310DateTimeDeserializerBase<T> jSR310DateTimeDeserializerBase, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super(jSR310DateTimeDeserializerBase, bl2);
        this._formatter = dateTimeFormatter;
        this._shape = shape;
    }

    protected abstract JSR310DateTimeDeserializerBase<T> withDateFormat(DateTimeFormatter var1);

    @Override
    protected abstract JSR310DateTimeDeserializerBase<T> withLeniency(Boolean var1);

    protected JSR310DateTimeDeserializerBase<T> withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, this.handledType());
        return value == null ? this : this._withFormatOverrides(deserializationContext, beanProperty, value);
    }

    protected JSR310DateTimeDeserializerBase<?> _withFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonFormat.Value value) {
        Object object;
        JSR310DeserializerBase jSR310DeserializerBase = this;
        if (value.hasLenient() && (object = value.getLenient()) != null) {
            jSR310DeserializerBase = ((JSR310DateTimeDeserializerBase)jSR310DeserializerBase).withLeniency((Boolean)object);
        }
        if (value.hasPattern()) {
            object = value.getPattern();
            Locale locale = value.hasLocale() ? value.getLocale() : deserializationContext.getLocale();
            DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
            if (this.acceptCaseInsensitiveValues(deserializationContext, value)) {
                dateTimeFormatterBuilder.parseCaseInsensitive();
            }
            dateTimeFormatterBuilder.appendPattern((String)object);
            DateTimeFormatter dateTimeFormatter = locale == null ? dateTimeFormatterBuilder.toFormatter() : dateTimeFormatterBuilder.toFormatter(locale);
            if (!jSR310DeserializerBase.isLenient()) {
                dateTimeFormatter = dateTimeFormatter.withResolverStyle(ResolverStyle.STRICT);
            }
            if (value.hasTimeZone()) {
                dateTimeFormatter = dateTimeFormatter.withZone(value.getTimeZone().toZoneId());
            }
            jSR310DeserializerBase = ((JSR310DateTimeDeserializerBase)jSR310DeserializerBase).withDateFormat(dateTimeFormatter);
        }
        if ((object = value.getShape()) != null && object != this._shape) {
            jSR310DeserializerBase = ((JSR310DateTimeDeserializerBase)jSR310DeserializerBase).withShape((JsonFormat.Shape)((Object)object));
        }
        return jSR310DeserializerBase;
    }

    private boolean acceptCaseInsensitiveValues(DeserializationContext deserializationContext, JsonFormat.Value value) {
        Boolean bl2 = value.getFeature(JsonFormat.Feature.ACCEPT_CASE_INSENSITIVE_VALUES);
        if (bl2 == null) {
            bl2 = deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
        }
        return bl2;
    }

    protected void _throwNoNumericTimestampNeedTimeZone(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportInputMismatch(this.handledType(), "raw timestamp (%d) not allowed for `%s`: need additional information such as an offset or time-zone (see class Javadocs)", jsonParser.getNumberValue(), this.handledType().getName());
    }
}

